#include "testApp.h"

testApp::testApp(bool ai, int pl){
    useAI=ai;
    ofSeedRandom();
    if(pl==1)//random then alternate
        firstPlayer=-((int)roundf(ofRandom(1,2)));
    else
        firstPlayer=pl-1;//AI is player 2
}

//--------------------------------------------------------------
void testApp::setup(){
    player=abs(firstPlayer);
    board=new int[9];
    canvasHeight=canvasWidth=300;
    canvas.allocate(canvasWidth,canvasHeight,GL_LUMINANCE);
    pixels=new unsigned char[canvasWidth*canvasHeight];
    clearBoard();
}

//--------------------------------------------------------------
void testApp::update(){
    Sleep(50);
    int pos[]={-1,-1,-1,-1,-1,-1,-1,-1,-1};
    int move=0;
    int cornerPatterns[]=
        {0, 3,6,1,2,4,8,
         2, 0,1,5,8,4,6,
         6, 3,0,7,8,4,2,
         8, 6,7,5,2,4,0};
    int sidePatterns[]=
        {1, 0,2,4,7,
         3, 0,6,4,5,
         5, 2,8,3,4,
         7, 6,8,1,4};
    int middlePatterns[]=
        {4, 0,8,1,7,2,6,3,5};
    if(turns>=9)
        checkWin();
    int current;
    if(player==2&&useAI){
        //process stuff and update

        /*types of moves:
        (2x) Force (move makes 2 in a row and forces opponent to block pattern)
            -inf    Force suicide- opponent forced to go as to complete row of 3
            3-rows of 2    Force negative- forced to go as to complete 1 or more rows of 2
            4    Force neutral- forced to go as to not complete any rows of 2
        (2x) Block (2 opposing pieces in a row need to be blocked)
            inf    Block victory- row of 3 completed by blocking
            5    Block neutral- no gain posed by blocking
            6+rows of 2    Block positive- contributes to complete 1 or more rows of 2 by blocking
        Strategic defense (no immediate effect)
            #of row/col/d made newly unavailable to opponent

        */
        if(turns==0){
            move=(int)roundf(ofRandom(0,8));
        }else{
            for(int corner=0;corner<4;corner++){
                current=7*corner;
                if(board[cornerPatterns[current]]!=0){
                    pos[cornerPatterns[current]]--;
                    continue;
                }
                for(int pattern=0;pattern<3;pattern++){
                    if(board[cornerPatterns[current+1+2*pattern]]==board[cornerPatterns[current+2*pattern+2]]){
                        switch(board[cornerPatterns[current+2*pattern+1]]){
                            case 0:
                                pos[cornerPatterns[current]]++;//one pattern is empty and made unavailable to opponent by going there
                                break;
                            case 1:
                                pos[cornerPatterns[current]]+=6;//block benefit
                                break;
                            case 2:
                                pos[cornerPatterns[current]]+=20;//win benefit
                                break;
                        }
                    }else{
                        switch(board[cornerPatterns[current+2*pattern+1]]+board[cornerPatterns[current+2*pattern+2]]){
                            case 1:
                                pos[cornerPatterns[current]]+=2;//one pattern has one piece and made unavailable to opponent by going there
                                break;
                            case 2:
                                if(board[cornerPatterns[current+2*pattern+1]]==2)
                                    pos[cornerPatterns[current]]+=(5-checkOpponentBenefit(cornerPatterns[current+2*pattern+2]));//force opponent to go to the middle location by going here
                                else
                                    pos[cornerPatterns[current]]+=(5-checkOpponentBenefit(cornerPatterns[current+2*pattern+1]));
                                break;
                            case 3:
                                //no real difference
                                break;
                        }
                    }
                }
            }

            for(int side=0;side<4;side++){
                current=5*side;
                if(board[sidePatterns[current]]!=0){
                    pos[sidePatterns[current]]--;
                    continue;
                }
                for(int pattern=0;pattern<2;pattern++){
                    if(board[sidePatterns[current+1+2*pattern]]==board[sidePatterns[current+2*pattern+2]]){
                        switch(board[sidePatterns[current+2*pattern+1]]){
                            case 0:
                                pos[sidePatterns[current]]++;//one pattern is empty and made unavailable to opponent by going there
                                break;
                            case 1:
                                pos[sidePatterns[current]]+=6;//block benefit
                                break;
                            case 2:
                                pos[sidePatterns[current]]+=20;//win benefit
                                break;
                        }
                    }else{
                        switch(board[sidePatterns[current+2*pattern+1]]+board[sidePatterns[current+2*pattern+2]]){
                            case 1:
                                pos[sidePatterns[current]]+=2;//one pattern has one piece and made unavailable to opponent by going there
                                break;
                            case 2:
                                if(board[sidePatterns[current+2*pattern+1]]==2)
                                    pos[sidePatterns[current]]+=(5-checkOpponentBenefit(sidePatterns[current+2*pattern+2]));//force opponent to go to the middle location by going here
                                else
                                    pos[sidePatterns[current]]+=(5-checkOpponentBenefit(sidePatterns[current+2*pattern+1]));
                                break;
                            case 3:
                                //no real difference
                                break;
                        }
                    }
                }
            }

            if(board[middlePatterns[0]]==0){
                for(int pattern=0;pattern<4;pattern++){
                    if(board[middlePatterns[1+2*pattern]]==board[middlePatterns[2*pattern+2]]){
                        switch(board[middlePatterns[2*pattern+1]]){
                            case 0:
                                pos[middlePatterns[0]]++;//one pattern is empty and made unavailable to opponent by going there
                                break;
                            case 1:
                                pos[middlePatterns[0]]+=6;//block benefit
                                break;
                            case 2:
                                pos[middlePatterns[0]]+=20;//win benefit
                                break;
                        }
                    }else{
                        switch(board[middlePatterns[2*pattern+1]]+board[middlePatterns[2*pattern+2]]){
                            case 1:
                                pos[middlePatterns[0]]+=2;//one pattern has one piece and made unavailable to opponent by going there
                                break;
                            case 2:
                                if(board[middlePatterns[2*pattern+1]]==2)
                                    pos[middlePatterns[0]]+=(5-checkOpponentBenefit(middlePatterns[2*pattern+2]));//force opponent to go to the middle location by going here
                                else
                                    pos[middlePatterns[0]]+=(5-checkOpponentBenefit(middlePatterns[2*pattern+1]));
                                break;
                            case 3:
                                //no real difference
                                break;
                        }
                    }
                }
            }else{
                pos[middlePatterns[0]]--;
            }

            int max=-1;
            int oc=0;
            for(int a=0;a<9;a++){
                if(pos[a]>max){
                    max=pos[a];
                    oc=1;
                }else{
                    if(pos[a]==max)
                        oc++;
                }
            }
            if(oc>1)
                oc=(int)roundf(ofRandom(1,oc));
            for(int a=0;a<9;a++){
                if(pos[a]==max)
                    oc--;
                if(oc==0){
                    move=a;
                    break;
                }
            }
        }
        /*do{
            move=(int)roundf(ofRandom(0,8));
        }while(board[move]!=0&&turns<9);*/

        board[move]=2;
        drawO(move);
        turns++;
        player=1;
        checkWin();
    }
}

//--------------------------------------------------------------
void testApp::draw(){
    canvas.draw(10,10);
    Sleep(50);
}

//--------------------------------------------------------------
void testApp::keyPressed(int key){
    key=key-49;
    if(key<0||key>8)
        return;
    if(board[key]!=0||player<=0)
        return;//already has a mark there
    if(player==1){//draw X
        board[key]=1;
        turns++;
        drawX(key);
        player=2;
    }else{//draw O
        if(!useAI){
            board[key]=2;
            turns++;
            drawO(key);
            player=1;
        }
    }
    if(player>0)
        checkWin();
}

//--------------------------------------------------------------
void testApp::keyReleased(int key){
    if(key==OF_KEY_RETURN){
        clearBoard();
        return;
    }
}

void testApp::checkWin(){
    int win=0;
    for(int r=0;r<3;r++)
        if(board[r*3]!=0&&board[r*3]==board[r*3+1]&&board[r*3+1]==board[r*3+2]){
            win=board[r*3];
            for(int y=(2-r)*100+25;y<(2-r)*100+75;y++)
                for(int x=25;x<275;x++)
                    pixels[y*canvasWidth+x]=~pixels[y*canvasWidth+x];
        }
    for(int c=0;c<3;c++)
        if(board[c]!=0&&board[c]==board[c+3]&&board[c+3]==board[c+6]){
            win=board[c];
            for(int y=25;y<275;y++)
                for(int x=c*100+25;x<c*100+75;x++)
                    pixels[y*canvasWidth+x]=~pixels[y*canvasWidth+x];
        }
    if(board[6]!=0&&board[6]==board[4]&&board[4]==board[2]){
        win=board[6];
        for(int y=25;y<275;y++)
                for(int x=-25;x<25;x++)
                    pixels[y*canvasWidth+y+x]=~pixels[y*canvasWidth+y+x];
    }
    if(board[0]!=0&&board[0]==board[4]&&board[4]==board[8]){
        win=board[0];
        for(int y=25;y<275;y++)
                for(int x=-25;x<25;x++)
                    pixels[(300-y)*canvasWidth+y+x]=~pixels[(300-y)*canvasWidth+y+x];
    }
    if(win!=0||turns>=9){
        player=0;
        turns=0;
        canvas.loadData(pixels,canvasWidth,canvasHeight,GL_LUMINANCE);
    }
}

void testApp::drawX(int pos){
    int x=pos%3;
    int y=2-(pos/3);
    x=x*100+25;
    y=y*100+25;
    for(int r=0;r<50;r++){
        pixels[(y+r)*canvasWidth+x+r]=255;
        pixels[(y+r)*canvasWidth+x+(50-r)]=255;
    }
    canvas.loadData(pixels,canvasWidth,canvasHeight,GL_LUMINANCE);
}

void testApp::drawO(int pos){
    int x=pos%3;
    int y=2-(pos/3);
    x=x*100+25;
    y=y*100+25;
    for(int r=0;r<50;r++){
        pixels[y*canvasWidth+x+r]=255;
        pixels[(y+50)*canvasWidth+x+r]=255;
        pixels[(y+r)*canvasWidth+x]=255;
        pixels[(y+r)*canvasWidth+x+50]=255;
    }
    canvas.loadData(pixels,canvasWidth,canvasHeight,GL_LUMINANCE);
}

void testApp::clearBoard(){
    if(firstPlayer<0){
        if(firstPlayer==-1)
            firstPlayer=-2;
        else
            firstPlayer=-1;
        player=-firstPlayer;
    }else
        player=firstPlayer;
    turns=0;
    for(int r=0;r<9;r++)
        board[r]=0;
    for(int r=0;r<canvasHeight;r++){
        for(int c=0;c<canvasWidth;c++){
            if((r>0&&c>0)&&(r%100==0||c%100==0))
                pixels[r*canvasWidth+c]=255;
            else
                pixels[r*canvasWidth+c]=0;
        }
    }
    canvas.loadData(pixels,canvasWidth,canvasHeight,GL_LUMINANCE);
}

int testApp::checkOpponentBenefit(int pos){
    int cornerPatterns[]=
        {0, 3,6,1,2,4,8,
         2, 0,1,5,8,4,6,
         6, 3,0,7,8,4,2,
         8, 6,7,5,2,4,0};
    int sidePatterns[]=
        {1, 0,2,4,7,
         3, 0,6,4,5,
         5, 2,8,3,4,
         7, 6,8,1,4};
    int middlePatterns[]=
        {4, 0,8,1,7,2,6,3,5};
    int current=0;
    int total=0;
    if(pos%2==1){
        current=5*((pos-1)/2);
        if(board[sidePatterns[current]]!=0)
            return 0;
        for(int pattern=0;pattern<2;pattern++){
            if(board[sidePatterns[current+1+2*pattern]]==board[sidePatterns[current+2*pattern+2]]){
                if(board[sidePatterns[current+2*pattern+1]]==1)
                    total+=10;//win benefit
            }else{
                if((board[sidePatterns[current+2*pattern+1]]+board[sidePatterns[current+2*pattern+2]])==1)
                    total+=2;//small block benefit
            }
        }
        return total;
    }else{
        if(pos==4){
            if(board[middlePatterns[0]]==0){
                for(int pattern=0;pattern<4;pattern++){
                    if(board[middlePatterns[1+2*pattern]]==board[middlePatterns[2*pattern+2]]){
                        if(board[middlePatterns[2*pattern+1]]==1)
                            total+=10;//win
                    }else{
                        if((board[middlePatterns[2*pattern+1]]+board[middlePatterns[2*pattern+2]])==1)
                            total+=2;
                    }
                }
                return total;
            }else
                return 0;
        }else{
            if(pos>2)
                pos-=2;
            current=7*(pos/2);
            if(board[cornerPatterns[current]]!=0)
                return 0;
            for(int pattern=0;pattern<3;pattern++){
                if(board[cornerPatterns[current+1+2*pattern]]==board[cornerPatterns[current+2*pattern+2]]){
                    if(board[cornerPatterns[current+2*pattern+1]]==1)
                        total+=10;
                }else{
                    if((board[cornerPatterns[current+2*pattern+1]]+board[cornerPatterns[current+2*pattern+2]])==1)
                        total+=2;
                }
            }
            return total;
        }
    }
}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){

}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::windowResized(int w, int h){

}

//--------------------------------------------------------------
void testApp::gotMessage(ofMessage msg){

}

//--------------------------------------------------------------
void testApp::dragEvent(ofDragInfo dragInfo){

}
