﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO.Ports;
using System.Windows;

namespace Oscilloscope
{
    class SerialReader
    {
        SerialPort comPort = null;
        double[] squaredReadings;
        int readingPointer;
        int numReadings = 1000;

        public SerialReader()
        {
            string[] pn = System.IO.Ports.SerialPort.GetPortNames();
            if (pn.Count() == 0)
            {
                MessageBox.Show("No COM ports found!", "Serial Error 1", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }
            try
            {
                comPort = new SerialPort("COM16", 115200, Parity.None, 8, StopBits.One);
                comPort.Open();
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message, "Serial Error 2", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }

            comPort.DtrEnable = true;
            //comPort.RtsEnable = true;
            comPort.DataReceived += new SerialDataReceivedEventHandler(comPort_DataReceived);

            squaredReadings = new double[numReadings];
            readingPointer = 0;
        }

        void comPort_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            int datain;
            while (comPort.BytesToRead >= 8)
            {
                string d = comPort.ReadLine();
                if (int.TryParse(d, out datain))
                {
                    //Osc.PlotPoint(datain);
                    squaredReadings[readingPointer] = Math.Pow(datain, 2);
                    readingPointer++;
                    if (readingPointer >= numReadings)
                        readingPointer = 0;
                }
            }

            double s = 0;
            for (int a = 0; a < numReadings; a++)
            {
                s = s + squaredReadings[a];
            }
            s = Math.Sqrt(s / numReadings);

            //Label.Text=s.ToString();
        }
    }
}
