﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.IO.Ports;

namespace Oscilloscope
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        //DispatcherTimer updater;
        SerialPort comPort = null;
        double[] squaredReadings;
        int readingPointer;
        int numReadings = 1000;

        public double rms_1s, rms_5s, rms_10s, rms_20s; //variables accessed by HTTP server

        public MainWindow()
        {
            InitializeComponent();

            /*updater = new DispatcherTimer();
            updater.Interval = TimeSpan.FromMilliseconds(50);
            updater.Tick += new EventHandler(updater_Tick);
            updater.Start();*/

            string[] pn = System.IO.Ports.SerialPort.GetPortNames();
            if (pn.Count() == 0)
            {
                MessageBox.Show("No COM ports found!", "Serial Error 1", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }
            try
            {
                comPort = new SerialPort(pn[0], 9600, Parity.None, 8, StopBits.One);
                comPort.Open();
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message, "Serial Error 2", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }

            //HttpOutput.start(this);

            //AudioOutput.start(this);

            //comPort.RtsEnable = true;

            comPort.DataReceived += new SerialDataReceivedEventHandler(comPort_DataReceived);

            squaredReadings = new double[numReadings];
            readingPointer = 0;
        }

        void comPort_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            int datain;
            while (comPort.BytesToRead >= 8)
            {
                string d = comPort.ReadLine();
                if (int.TryParse(d, out datain))
                {
                    Osc.PlotPoint(datain);
                    //AudioOutput.AddBuffer(datain);
                    squaredReadings[readingPointer] = Math.Pow(datain, 2);
                    readingPointer++;
                    if (readingPointer >= numReadings)
                        readingPointer = 0;
                }
            }

            double s = 0;
            int aptr = readingPointer;
            for (int a = 0; a < 50; a++)
            {
                s = s + squaredReadings[aptr];
                aptr--;
                if (aptr < 0)
                    aptr = numReadings - 1;
            }
            rms_1s = Math.Sqrt(s / 50);

            for (int a = 0; a < 200; a++)
            {
                s = s + squaredReadings[aptr];
                aptr--;
                if (aptr < 0)
                    aptr = numReadings - 1;
            }
            rms_5s = Math.Sqrt(s / 250);

            for (int a = 0; a < 250; a++)
            {
                s = s + squaredReadings[aptr];
                aptr--;
                if (aptr < 0)
                    aptr = numReadings - 1;
            }
            rms_10s = Math.Sqrt(s / 500);

            for (int a = 0; a < 500; a++)
            {
                s = s + squaredReadings[aptr];
                aptr--;
                if (aptr < 0)
                    aptr = numReadings - 1;
            }
            rms_20s = Math.Sqrt(s / 1000);

            this.Dispatcher.Invoke(new Action(() => { RmsValue.Content = rms_20s.ToString("0.0"); }));
        }

        private void StartButton_Click(object sender, RoutedEventArgs e)
        {
            if (comPort.DtrEnable)
            {
                comPort.DtrEnable = false;
                StartButton.Content = "Start";
            }
            else
            {
                comPort.DtrEnable = true;
                StartButton.Content = "Stop";
            }
        }

        /*void updater_Tick(object sender, EventArgs e)
        {
            Osc.PlotPoint(rnd.NextDouble());
            Osc.PlotPoint(rnd.NextDouble());
            Osc.PlotPoint(rnd.NextDouble());
            Osc.PlotPoint(rnd.NextDouble());
            //Osc.ClearPlot();
        }*/
    }
}
