﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Threading;
using System.IO;
using System.Net.Sockets;
using System.Security.Cryptography;

namespace Oscilloscope
{
    class HttpOutput
    {
        private static String address;
        private static Thread listenThread;
        private static Thread socketThread;
        private static HttpListener listener;
        private static TcpListener socketServer;
        private static MainWindow mw;

        public static void start(MainWindow datasource)
        {
            mw = datasource;

            //c.WriteLine("[{0:HH:mm}] Initializing", DateTime.Now);

            // setup thread
            listenThread = new Thread(WorkerHTTP);
            listenThread.IsBackground = true;
            listenThread.Priority = ThreadPriority.Normal;

            socketThread = new Thread(WorkerSocket);
            socketThread.IsBackground = true;
            socketThread.Priority = ThreadPriority.Normal;

            // the address we want to listen on
            address = "http://*:80/";

            // setup http listener
            listener = new HttpListener();
            listener.Prefixes.Add(address);

            //setup socket listener
            socketServer = new TcpListener(IPAddress.Any, 8181);

            // Gogogo
            listenThread.Start(null);

            socketThread.Start(null);

            // prevent the console window from closing
            //while (true) c.ReadKey(true);
        }

        private static void WorkerSocket(object state)
        {
            // start the listener
            socketServer.Start();

            //Console.WriteLine("A client connected.");

            while (true) {
                // check for any incoming pending connections
                // create new socket client for new connection
                TcpClient socketConnection = socketServer.AcceptTcpClient();

                //parentForm.ApplyText("New Client Connected - " + now.ToString("MM/dd/yyyy h:mm:ss tt") + "\r\n");

                // create a reader for this client
                StreamReader reader = new StreamReader(socketConnection.GetStream());
                // create a writer for this client
                StreamWriter writer = new StreamWriter(socketConnection.GetStream());

                var headers = new Dictionary<string, string>();

                string line = "";
                while ((line = reader.ReadLine()) != string.Empty)
                {
                    if (!string.IsNullOrEmpty(line))
                    {
                        var tokens = line.Split(new char[] { ':' }, 2);
                        if (!string.IsNullOrWhiteSpace(line) && tokens.Length > 1)
                        {
                            headers[tokens[0]] = tokens[1].Trim();
                        }
                    }
                }

                string host = headers["Host"]; //format: 127.0.0.1:8181
                string orgn = headers["Origin"]; //format: http://127.0.0.1

                String secWebSocketAccept = ComputeWebSocketHandshakeSecurityHash09(headers["Sec-WebSocket-Key"]);

                // send handshake to this client only
                writer.WriteLine("HTTP/1.1 101 Web Socket Protocol Handshake");
                writer.WriteLine("Upgrade: WebSocket");
                writer.WriteLine("Connection: Upgrade");
                writer.WriteLine("WebSocket-Origin: " + orgn);
                writer.WriteLine("WebSocket-Location: ws://" + host);
                writer.WriteLine("Sec-WebSocket-Accept: " + secWebSocketAccept);
                writer.WriteLine("");
                writer.Flush();

                NetworkStream l_Stream = socketConnection.GetStream();
                byte[] bar = new byte[150];

                /*Thread.Sleep(1000);

                string message = "This is a test message!";

                bar[0] = 0x81;
                bar[1] = (byte)message.Length;
                Encoding.UTF8.GetBytes(message, 0, message.Length, bar, 2);
                l_Stream.Write(bar, 0, bar[1] + 2);*/

                Random rn = new Random();
                int nrcounter = 0;

                try {
                    while (true)
                    {//communicate with client until connection fails and exception gets thrown, then close connection
                        while (!l_Stream.DataAvailable && nrcounter < 500)
                        {
                            Thread.Sleep(10);
                            nrcounter++;
                        }

                        if (nrcounter == 500)
                        {//5 seconds of inactivity -> close connection
                            break;
                        }

                        nrcounter = 0;

                        int numbytes = l_Stream.Read(bar, 0, bar.Length);

                        if (bar[0] != 129)
                            break; //a non-text frame received: close connection

                        //We could process supplied text below, here we just write back current values for any given input
                        /*int msglen = bar[1] & 0x7F;
                        int keyb = 2;
                        for(int msgb=0; msgb < msglen; msgb++)
                        {
                            bar[6 + msgb] ^= bar[keyb];
                            keyb++;
                            if (keyb > 5)
                                keyb = 2;
                        }

                        string msgin = Encoding.UTF8.GetString(bar, 6, msglen);

                        message = "You typed: " + msgin;*/

                        StringBuilder html = new StringBuilder();
                        html.Append("1 sec rms:  ");
                        html.AppendFormat("{0:F1}", mw.rms_1s);
                        html.Append("<br/>");
                        html.Append("5 sec rms:  ");
                        html.AppendFormat("{0:F1}", mw.rms_5s);
                        html.Append("<br/>");
                        html.Append("10 sec rms: ");
                        html.AppendFormat("{0:F1}", mw.rms_10s);
                        html.Append("<br/>");
                        html.Append("20 sec rms: ");
                        html.AppendFormat("{0:F1}", mw.rms_20s);

                        string message = html.ToString();
                        int mslen = 0;
                        if (message.Length < 126)
                        {
                            bar[0] = 0x81;
                            bar[1] = (byte)message.Length;
                            Encoding.UTF8.GetBytes(message, 0, message.Length, bar, 2);
                            mslen = message.Length + 2;
                        }
                        else
                        {// up to 65536 bytes
                            bar[0] = 0x81;
                            bar[1] = 126;
                            bar[2] = (byte)((message.Length >> 8) & 0xFF);
                            bar[3] = (byte)(message.Length & 0xFF);
                            Encoding.UTF8.GetBytes(message, 0, message.Length, bar, 4);
                            mslen = message.Length + 4;
                        }
                        l_Stream.Write(bar, 0, mslen);
                    }

                    //if (bar[0] == 136)//closing message received, we will send a confirmation right back
                    //{
                    bar[0] = 136;
                    bar[1] = 0;//zero length message to send back
                    l_Stream.Write(bar, 0, 2);
                    //}
                }
                catch (Exception)
                {
                    //connection has been broken, carry on
                }

                socketConnection.Close();
            }
        }

        public static String ComputeWebSocketHandshakeSecurityHash09(String secWebSocketKey)
        {
            const String MagicKEY = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            String secWebSocketAccept = String.Empty;

            // 1. Combine the request Sec-WebSocket-Key with magic key.
            String ret = secWebSocketKey + MagicKEY;

            // 2. Compute the SHA1 hash
            SHA1 sha = new SHA1CryptoServiceProvider();
            byte[] sha1Hash = sha.ComputeHash(Encoding.UTF8.GetBytes(ret));

            // 3. Base64 encode the hash
            secWebSocketAccept = Convert.ToBase64String(sha1Hash);

            return secWebSocketAccept;
        }

        private static void WorkerHTTP(object state)
        {
            // start listening
            listener.Start();

            //Console.WriteLine("A client connected.");

            //c.WriteLine("[{0:HH:mm}] Running", DateTime.Now);

            //Socket sck = listener.AcceptSocket();

            byte[] bytes = new byte[1024];

            //sck.Send(bytes, 15, SocketFlags.None);

            // request -> response loop
            while (true)
            {
                HttpListenerContext context = listener.GetContext();
                HttpListenerRequest request = context.Request;

                /* respond to the request.
                 * in this case it'll show "Server appears to be working".
                 * regardless of what file/path was requested.
                 */

                //Random rn = new Random();

                using (HttpListenerResponse response = context.Response)
                {
                    StringBuilder html = new StringBuilder();

                    //The commented out section does everything in HTTP, the one below uses websockets for more elegant comms
                    /*if (request.QueryString.Count > 0) //some data was requested
                    {
                        html.Append("1 sec rms:  ");
                        html.Append(mw.rms_1s);
                        html.Append("<br/>");
                        html.Append("5 sec rms:  ");
                        html.Append(mw.rms_5s);
                        html.Append("<br/>");
                        html.Append("10 sec rms: ");
                        html.Append(mw.rms_10s);
                        html.Append("<br/>");
                        html.Append("20 sec rms: ");
                        html.Append(mw.rms_20s);
                    }
                    else
                    {
                        html.Append("<!DOCTYPE html><html><body><button onclick='bp()'>Go!</button><pre id='op'></pre><script>var w=false;var t=0;function bp(){if(t==0){t=setInterval(lx, 1000);}else{clearInterval(t);t=0;}}function lx(){if(w)return;var x=new XMLHttpRequest();x.onreadystatechange=rx;w=true;x.open('GET','?u',true);x.send();}function rx(){if(this.readyState==4&&this.status==200){document.getElementById('op').innerHTML=this.responseText;w=false;}}</script></body></html>");
                    }*/

                    html.Append("<!DOCTYPE html><html><body><button onclick='bp();' id='bn'>Go!</button><pre id='op'></pre><script>var s=false;var t=0;var w=new WebSocket('ws://'+document.location.hostname+':8181/');w.onopen=function(){wr('op','WS Connection Ready!');};w.onclose=function(){if(t!=0)clearInterval(t);wr('op','WS Connection Closed.');wr('bn','X_X');};w.onmessage=function(e){wr('op',e.data);s=false;};function bp(){if(t==0){wr('bn','Stop');t=setInterval(lx,300);}else{clearInterval(t);t=0;wr('bn','Go!');}}function lx(){if(s)return;s=true;w.send('');}function wr(i,m){document.getElementById(i).innerHTML=m;}</script></body></html>");

                    byte[] data = Encoding.UTF8.GetBytes(html.ToString());

                    response.ContentType = "text/html";
                    response.ContentLength64 = data.Length;

                    using (Stream output = response.OutputStream)
                    {
                        output.Write(data, 0, data.Length);
                    }
                }
            }
        }
    }
}
