﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NAudio.Wave;

namespace Oscilloscope
{
    class AudioOutput
    {
        private static MainWindow mw;
        private static WaveOut waveOut;
        private static BufferedWaveProvider AMWaveProvider;
        private static int buffers_out;
        private static int stime;
        private const int srate = 16000; //sample rate (Hz)
        private const int bnum = 316; //buffer add bytes [byte]
        private const double cfreq = 120; //carrier wave frequency (Hz)
        private static byte[] audioBuffer;
        private const short amplitude = 10000; //carrier wave amplitude (as fraction of 32767)

        public static void start(MainWindow datasource)
        {
            mw = datasource;
            buffers_out = 0; //space it so at least 2 serial port writes are available before playing
            stime = 0; //time to generate sound wave
            audioBuffer = new byte[bnum * 2];
            if (waveOut == null)
            {
                AMWaveProvider = new BufferedWaveProvider(new WaveFormat(srate, 1));
                //AMWaveProvider.BufferDuration = TimeSpan.FromSeconds(0.5);
                
                waveOut = new WaveOut();
                waveOut.Init(AMWaveProvider);
                //waveOut.Play();
            }
            else
            {
                waveOut.Stop();
                waveOut.Dispose();
                waveOut = null;
            }
        }

        public static void AddBuffer(int value)
        {//value ranges from short.min (-32768) to 32767
            double am = (value + 3276.8) / 6553.60; //extent of amplitude modulation

            if (am < 0)
                am = 0;
            if (am > 1)
                am = 1;

            for (int n = 0; n < audioBuffer.Length; n+=2)
            {
                double sin = Math.Sin((2 * Math.PI * cfreq * stime) / srate); //sine carrier wave

                short bit = (short) (amplitude * sin * am);

                audioBuffer[n] = (byte)bit;
                audioBuffer[n + 1] = (byte)(bit >> 8);

                stime++;
                if (stime >= srate)
                    stime = 0;
            }

            AMWaveProvider.AddSamples(audioBuffer, 0, audioBuffer.Length);
            if (buffers_out < 3) 
            {
                buffers_out++;
                if (buffers_out == 3)
                    waveOut.Play();//we have 3 buffers ready so start playing
            }
        }

        public class SineWaveProvider16 : WaveProvider16
        {
            int sample;

            public SineWaveProvider16()
            {
                Frequency = 1000;
                Amplitude = 100; // let's not hurt our ears            
            }

            public float Frequency { get; set; }
            public float Amplitude { get; set; }

            public override int Read(short[] buffer, int offset, int sampleCount)
            {
                int sampleRate = WaveFormat.SampleRate;
                for (int n = 0; n < sampleCount; n++)
                {
                    buffer[n + offset] = (short)(Amplitude * Math.Sin((2 * Math.PI * sample * Frequency) / sampleRate));
                    sample++;
                    if (sample >= sampleRate) sample = 0;
                }
                return sampleCount;
            }
        }
    }
}
