﻿using System;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Shapes;

namespace Photogrammetry
{
    class ProjectedAxis
    {
        public Line primary, secondary;
        public bool IsReady()
        {
            return primary != null && secondary != null;
        }
    }

    class ProjectedPlane
    {
        public ProjectedAxis axis1, axis2;
        public Line a1ref1, a1ref2, a2ref1, a2ref2, measLine;

        public bool IsReady()
        {
            if(axis1 == null || axis2 == null || a1ref1 == null || a1ref2 == null || a2ref1 == null || a2ref2 == null || measLine == null)
            {
                return false;
            }
            return axis1.IsReady() && axis2.IsReady();
        }

        /*public ProjectedPlane()
        {
            axis1 = new ProjectedAxis();
            axis2 = new ProjectedAxis();
        }*/

        public ParametricLine GetLineThrough(Point thru, bool vpAxis1)
        {
            ProjectedAxis pa = vpAxis1 ? axis1 : axis2;
            //complete the intersections of the reference lines to get a rectangle
            ParametricLine pl1 = new ParametricLine(pa.primary);
            ParametricLine pl2 = new ParametricLine(pa.secondary);
            VanishingPoint vp = new VanishingPoint(pl1, pl2);
            return vp.ProjectThrough(thru);
        }
    }

    class ProjectedCube
    {
        
        public ProjectedAxis X, Y, Z;
        public Point? originPt;
        public Line originLineX, originLineY, originLineZ;

        public bool IsReady()
        {
            if(originPt == null || X == null || Y == null || Z == null)
            {
                return false;
            }
            return X.IsReady() && Y.IsReady() && Z.IsReady();
        }

        /*public ProjectedCube()
        {
            XY = new ProjectedPlane();
            YZ = new ProjectedPlane();
            ZX = new ProjectedPlane();
        }*/
    }
}
