﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Photogrammetry
{
    /// <summary>
    /// Interaction logic for ProjGenControl.xaml
    /// </summary>
    public partial class ProjGenControl : ProjControlBase
    {
        string activeTool = null;

        public ProjGenControl(Canvas mainCanvas) : base(mainCanvas)
        {
            InitializeComponent();
        }

        public override void SetTool(string toolName)
        {
            if (double.IsNaN(myCanvas.Width))
            {
                return;
            }
            activeTool = toolName;
        }

        public override void ApplyTool(Point selectPt, bool rightClick)
        {
            if (activeTool == null || myCanvas == null)
            {
                return;
            }
        }

        public override Point GetSelectionPt(bool rightClick)
        {
            if (activeTool == null || myCanvas == null)
            {
                return new Point();
            }
            return new Point();
        }
    }
}
