﻿using System;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Shapes;

namespace Photogrammetry
{
    public abstract class ProjControlBase : UserControl
    {
        protected Canvas myCanvas;
        protected List<Line> measLines;

        protected readonly static Brush RefLineBrush = Brushes.Magenta;
        protected readonly static Brush MeasLineBrush = Brushes.Orange;
        protected readonly static Brush XAxisBrush = Brushes.Red;
        protected readonly static Brush YAxisBrush = Brushes.Blue;
        protected readonly static Brush ZAxisBrush = Brushes.Lime;

        public ProjControlBase(Canvas mainCanvas)
        {
            myCanvas = mainCanvas;
            measLines = new List<Line>();
        }

        ~ProjControlBase()
        {
            Clear();
        }

        public void Clear()
        {
            if (measLines == null || myCanvas == null || measLines.Count == 0)
            {
                return;
            }

            myCanvas.Dispatcher.BeginInvoke((Action)(() =>
            {
                foreach (Line lrm in measLines)
                {
                    myCanvas.Children.Remove(lrm);
                }
            }));
        }

        protected Line MakeLine(Brush lstroke, bool dashed = false)
        {
            Line lrm = new Line
            {
                X1 = 0,
                Y1 = 0,
                X2 = myCanvas.Width - 1,
                Y2 = myCanvas.Height - 1,
                Stroke = lstroke
            };
            if (dashed)
            {
                DoubleCollection dd = new DoubleCollection(2)
                {
                    2,
                    1
                };
                lrm.StrokeDashArray = dd;
            }
            measLines.Add(lrm);
            myCanvas.Children.Add(lrm);
            return lrm;
        }

        public void Show(bool yes)
        {
            if (myCanvas == null || measLines == null)
            {
                return;
            }
            foreach (Line l0 in measLines)
            {
                l0.Visibility = yes ? Visibility.Visible : Visibility.Hidden;
            }
        }

        public static Point GetLineEnd(Line ln, bool first)
        {
            if (first)
            {
                return new Point(ln.X1, ln.Y1);
            }
            else
            {
                return new Point(ln.X2, ln.Y2);
            }
        }

        public static void AdjustLine(Line lrm, bool firstPt, Point newLocation)
        {
            if (firstPt)
            {
                lrm.X1 = newLocation.X;
                lrm.Y1 = newLocation.Y;
            }
            else
            {
                lrm.X2 = newLocation.X;
                lrm.Y2 = newLocation.Y;
            }
        }

        public abstract void SetTool(string toolName);

        public abstract void ApplyTool(Point selectPt, bool rightClick);

        public abstract Point GetSelectionPt(bool rightClick);
    }
}
