﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace Photogrammetry
{
    /// <summary>
    /// Interaction logic for LineProjControl.xaml
    /// </summary>
    public partial class LineProjControl : ProjControlBase
    {
        ProjectedAxis M1p = null;
        string activeTool = null;

        public LineProjControl(Canvas mainCanvas) : base(mainCanvas)
        {
            InitializeComponent();
        }

        private void ToolButton_Checked(object sender, RoutedEventArgs e)
        {
            RadioButton snd = (RadioButton)sender;
            SetTool((string)snd.Content);
            e.Handled = true;
        }

        private void Scale_TextChanged(object sender, TextChangedEventArgs e)
        {
            runComputation();
        }

        public override void SetTool(string toolName)
        {
            if (double.IsNaN(myCanvas.Width))
            {
                return;
            }
            activeTool = toolName;
            if (M1p == null)
            {
                M1p = new ProjectedAxis();
            }
            switch (toolName)
            {
                case "Ref":
                    if (M1p.primary == null)
                    {
                        M1p.primary = MakeLine(RefLineBrush);
                    }
                    break;
                case "Meas":
                    if (M1p.secondary == null)
                    {
                        M1p.secondary = MakeLine(MeasLineBrush);
                    }
                    break;
                default:
                    activeTool = null;
                    break;
            }
        }

        public override void ApplyTool(Point selectPt, bool rightClick)
        {
            if (activeTool == null || myCanvas == null)
            {
                return;
            }
            if (M1p != null)
            {
                switch (activeTool)
                {
                    case "Ref":
                        if (M1p.primary != null)
                        {
                            AdjustLine(M1p.primary, !rightClick, selectPt);
                        }
                        break;
                    case "Meas":
                        if (M1p.secondary != null)
                        {
                            AdjustLine(M1p.secondary, !rightClick, selectPt);
                        }
                        break;
                }
                runComputation();
            }
        }

        public override Point GetSelectionPt(bool rightClick)
        {
            if (activeTool == null || myCanvas == null)
            {
                return new Point();
            }
            if (M1p != null)
            {
                switch (activeTool)
                {
                    case "Ref":
                        if (M1p.primary != null)
                        {
                            return GetLineEnd(M1p.primary, !rightClick);
                        }
                        break;
                    case "Meas":
                        if (M1p.secondary != null)
                        {
                            return GetLineEnd(M1p.secondary, !rightClick);
                        }
                        break;
                }
            }
            return new Point();
        }

        private void UserControl_IsVisibleChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            Show((bool)e.NewValue);
            if((bool)e.NewValue == true)
            {
                //reset tool and update event handler
            }
        }

        private void runComputation()
        {
            if(!IsInitialized)
            {
                return;
            }
            
            if (M1p == null || !M1p.IsReady())
            {
                M1resl.Text = "L";
                M1resa.Text = "A";
                return;
            }

            double reflen;
            if(!double.TryParse(M1refl.Text, out reflen))
            {
                reflen = double.NaN;
            }

            ParametricLine pl01 = new ParametricLine(M1p.primary);
            ParametricLine pl02 = new ParametricLine(M1p.secondary);
            double refl = reflen / pl01.NormDist; //<length>/<pixel>
            double lr = refl * pl02.NormDist; //<length>
            double la = -pl01.AngleTo(pl02) / Math.PI * 180; //[deg]
            M1resl.Text = "L : " + lr.ToString("G4") + " <len>";
            M1resa.Text = "A : " + la.ToString("G4") + " [deg]";
        }
    }
}
