﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Shapes;

namespace Photogrammetry
{
    /// <summary>
    /// Interaction logic for Cube2ProjControl.xaml
    /// </summary>
    public partial class Cube2ProjControl : ProjControlBase
    {
        string activeTool = null;
        ProjectedCube PC;

        public Cube2ProjControl(Canvas mainCanvas) : base(mainCanvas)
        {
            InitializeComponent();
        }

        private void ToolButton_Checked(object sender, RoutedEventArgs e)
        {
            RadioButton snd = (RadioButton)sender;
            SetTool((string)snd.Content);
            e.Handled = true;
        }

        private void Scale_TextChanged(object sender, TextChangedEventArgs e)
        {
            runComputation();
        }

        public override void SetTool(string toolName)
        {
            if (double.IsNaN(myCanvas.Width))
            {
                return;
            }
            activeTool = toolName;
            if (PC == null)
            {
                PC = new ProjectedCube();
                PC.X = new ProjectedAxis();
                PC.Y = new ProjectedAxis();
                PC.Z = new ProjectedAxis();
            }
            switch (toolName)
            {
                case "X vp1":
                    if (PC.X.primary == null)
                    {
                        PC.X.primary = MakeLine(XAxisBrush, true);
                    }
                    break;
                case "X vp2":
                    if (PC.X.secondary == null)
                    {
                        PC.X.secondary = MakeLine(XAxisBrush, true);
                    }
                    break;
                case "Y vp1":
                    if (PC.Y.primary == null)
                    {
                        PC.Y.primary = MakeLine(YAxisBrush, true);
                    }
                    break;
                case "Y vp2":
                    if (PC.Y.secondary == null)
                    {
                        PC.Y.secondary = MakeLine(YAxisBrush, true);
                    }
                    break;
                case "Z vp1":
                    if (PC.Z.primary == null)
                    {
                        PC.Z.primary = MakeLine(ZAxisBrush, true);
                    }
                    break;
                case "Z vp2":
                    if (PC.Z.secondary == null)
                    {
                        PC.Z.secondary = MakeLine(ZAxisBrush, true);
                    }
                    break;
                case "Corner":
                    if (PC.X.IsReady() && PC.Y.IsReady() && PC.Z.IsReady())
                    {
                        if (PC.originPt == null)
                        {
                            PC.originPt = new Point(myCanvas.Width / 2, myCanvas.Height / 2);
                            PC.originLineX = MakeLine(Brushes.Red);
                            PC.originLineY = MakeLine(Brushes.Blue);
                            PC.originLineZ = MakeLine(Brushes.Green);
                            adjustOriginPt(PC.originPt.Value);
                        }
                    }
                    else
                    {
                        activeTool = null;
                    }
                    break;
                /*case "Ref":
                    if (M2p.a1ref1 == null)
                    {
                        M2p.a1ref1 = MakeLine(RefLineBrush);
                    }
                    break;
                case "Meas":
                    if (M2p.measLine == null)
                    {
                        M2p.measLine = MakeLine(MeasLineBrush);
                    }
                    break;*/
                default:
                    activeTool = null;
                    break;
            }
        }

        public override void ApplyTool(Point selectPt, bool rightClick)
        {
            if (PC != null)
            {
                switch (activeTool)
                {
                    case "X vp1":
                        if (PC.X.primary != null)
                        {
                            AdjustLine(PC.X.primary, !rightClick, selectPt);
                        }
                        if (PC.originPt != null)
                        {
                            adjustOriginPt(PC.originPt.Value);
                        }
                        break;
                    case "X vp2":
                        if (PC.X.secondary != null)
                        {
                            AdjustLine(PC.X.secondary, !rightClick, selectPt);
                        }
                        if (PC.originPt != null)
                        {
                            adjustOriginPt(PC.originPt.Value);
                        }
                        break;
                    case "Y vp1":
                        if (PC.Y.primary != null)
                        {
                            AdjustLine(PC.Y.primary, !rightClick, selectPt);
                        }
                        if (PC.originPt != null)
                        {
                            adjustOriginPt(PC.originPt.Value);
                        }
                        break;
                    case "Y vp2":
                        if (PC.Y.secondary != null)
                        {
                            AdjustLine(PC.Y.secondary, !rightClick, selectPt);
                        }
                        if (PC.originPt != null)
                        {
                            adjustOriginPt(PC.originPt.Value);
                        }
                        break;
                    case "Z vp1":
                        if (PC.Z.primary != null)
                        {
                            AdjustLine(PC.Z.primary, !rightClick, selectPt);
                        }
                        if (PC.originPt != null)
                        {
                            adjustOriginPt(PC.originPt.Value);
                        }
                        break;
                    case "Z vp2":
                        if (PC.Z.secondary != null)
                        {
                            AdjustLine(PC.Z.secondary, !rightClick, selectPt);
                        }
                        if (PC.originPt != null)
                        {
                            adjustOriginPt(PC.originPt.Value);
                        }
                        break;
                    case "Corner":
                        if(PC.originPt != null)
                        {
                            adjustOriginPt(selectPt);
                        }
                        break;
                    /*case "Ref":
                        if (M2p.a1ref1 != null)
                        {
                            AdjustLine(M2p.a1ref1, !rightClick, selectPt);
                        }
                        break;
                    case "Meas":
                        if (M2p.measLine != null)
                        {
                            AdjustLine(M2p.measLine, !rightClick, selectPt);
                        }
                        break;*/
                }
                runComputation();
            }
        }

        void adjustOriginPt(Point selectPt)
        {
            VanishingPoint xvp = new VanishingPoint(new ParametricLine(PC.X.primary), new ParametricLine(PC.X.secondary));
            VanishingPoint yvp = new VanishingPoint(new ParametricLine(PC.Y.primary), new ParametricLine(PC.Y.secondary));
            VanishingPoint zvp = new VanishingPoint(new ParametricLine(PC.Z.primary), new ParametricLine(PC.Z.secondary));

            adjustTickLine(PC.originLineX, xvp.ProjectThrough(selectPt));
            adjustTickLine(PC.originLineY, yvp.ProjectThrough(selectPt));
            adjustTickLine(PC.originLineZ, zvp.ProjectThrough(selectPt));

            PC.originPt = selectPt;
        }

        void adjustTickLine(Line lrm, ParametricLine pl)
        {
            Point xl1 = pl.Traverse(10);
            Point xl2 = pl.Traverse(-10);
            lrm.X1 = xl1.X;
            lrm.Y1 = xl1.Y;
            lrm.X2 = xl2.X;
            lrm.Y2 = xl2.Y;
            lrm.Tag = pl.Offset;
        }

        public override Point GetSelectionPt(bool rightClick)
        {
            if (activeTool == null || myCanvas == null)
            {
                return new Point();
            }
            if (PC != null)
            {
                switch (activeTool)
                {
                    case "X vp1":
                        if (PC.X.primary != null)
                        {
                            return GetLineEnd(PC.X.primary, !rightClick);
                        }
                        break;
                    case "X vp2":
                        if (PC.X.secondary != null)
                        {
                            return GetLineEnd(PC.X.secondary, !rightClick);
                        }
                        break;
                    case "Y vp1":
                        if (PC.Y.primary != null)
                        {
                            return GetLineEnd(PC.Y.primary, !rightClick);
                        }
                        break;
                    case "Y vp2":
                        if (PC.Y.secondary != null)
                        {
                            return GetLineEnd(PC.Y.secondary, !rightClick);
                        }
                        break;
                    case "Z vp1":
                        if (PC.Z.primary != null)
                        {
                            return GetLineEnd(PC.Z.primary, !rightClick);
                        }
                        break;
                    case "Z vp2":
                        if (PC.Z.secondary != null)
                        {
                            return GetLineEnd(PC.Z.secondary, !rightClick);
                        }
                        break;
                    case "Corner":
                        if(PC.originPt != null)
                        {
                            return PC.originPt.Value;
                        }
                        break;
                    /*case "Ref":
                        if (M2p.a1ref1 != null)
                        {
                            return GetLineEnd(M2p.a1ref1, !rightClick);
                        }
                        break;
                    case "Meas":
                        if (M2p.measLine != null)
                        {
                            return GetLineEnd(M2p.measLine, !rightClick);
                        }
                        break;*/
                }
            }
            return new Point();
        }

        private void UserControl_IsVisibleChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            Show((bool)e.NewValue);
            if ((bool)e.NewValue == true)
            {
                //reset tool and update event handler
            }
        }

        private void runComputation()
        {
            if (!IsInitialized)
            {
                return;
            }

            if (PC == null || !PC.IsReady() || PC.originPt == null)
            {
                /*M2aresl.Text = "L";
                M2aresa.Text = "A";
                M2arest.Text = "T";
                M2note.Text = "Not ready";*/
                return;
            }

        }
    }
}
