﻿using System.ComponentModel;

namespace MCalcConsole
{
    internal abstract class StackEntry : INotifyPropertyChanged
    {
        public string? TypedEntry
        {
            get { return _typedEntry; }
            set
            {
                _typedEntry = value; PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("TypedEntry"));
                //else { throw new Exception("Cannot modify typed entry"); }
            }
        }
        string? _typedEntry;
        /*public double? Result
        {
            get { return _result; }
            set
            {
                _result = value; PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("Result"));
                //else { throw new Exception("Cannot modify result"); }
            }
        }
        double? _result;*/
        public string? Comment
        {
            get { return _comment; }
            set
            {
                _comment = value; PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("Comment"));
            }
        }
        string? _comment;
        public string? AR
        {
            get { return _AR; }
            set { _AR = value; PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("AR")); }
        }
        string? _AR;
        public event PropertyChangedEventHandler? PropertyChanged;
    }

    internal class ErrorSE : StackEntry
    {
        public Exception? myException;
    }

    internal class CommentSE : StackEntry
    {

    }

    internal class ValueSE : StackEntry
    {
        internal required double value;
    }

    internal class CommandSE : StackEntry
    {
        internal List<SRSingle>? cmdrefs;
        internal required string cmdword;
        internal string? sarg;
        internal int mlin = 0, mlout = 0, prefs = 0;
    }

    internal class HDCommandSE : CommandSE
    {
        internal SortedList<int, int>? supplyInds;
        internal List<SRSingle>? drefs;
        internal List<int>? fwdpath;
        internal List<(int, int)>? revpath;
        internal int fn;
    }

    internal class InputCommand : StackEntry
    {
        internal List<StackReference>? cmdrefs;
        internal required string cmdword;
        internal string? sarg;
        internal int prefs = 0;
    }
}
