﻿namespace MCalcConsole
{
    internal class Program
    {
        public static int[] layout_indices = { 0, 4, 30, 53, 80 }; //AR, Typed Entry, Result, Comment, end

        static void Main(string[] args)
        {
            StackEntriesConsole myItems = new StackEntriesConsole();
            Parser myParser = new Parser() { myStack = myItems };
            Processor myProcessor = new Processor() { myStack = myItems };
            layout_indices[4] = int.Max(Console.BufferWidth - 1, layout_indices[4]); ;
            Console.SetCursorPosition(layout_indices[1], 0);
            int maxl = layout_indices[2] - layout_indices[1];
            int lineswritten = 0;
            while (true)
            {
                string? li = Console.ReadLine();
                if (li == null)
                    li = "";
                //erase entry and return the starting line
                int nchars = li.Length;
                int nlines = (nchars + layout_indices[1]) / Console.BufferWidth;
                int rc = Console.CursorTop - 1;
                int rr = rc - nlines;
                if (rr < 0) rr = 0;
                for(int lc = rr; lc<=rc; lc++)
                {
                    ClearLine(lc);
                }
                if (li == Processor.exit_cmd)
                    return;
                try
                {
                    Console.SetCursorPosition(0, rr);
                    double? v;
                    StackEntry se = myParser.ParseInput(li);
                    if (se is ValueSE || se is CommentSE)
                    {
                        
                        if(se is ValueSE)
                        {
                            myItems.AddToStack(se, ((ValueSE)se).value, rr);
                        }
                        else
                        {
                            myItems.AddToStack(se, null, rr);
                        }
                    }
                    else
                    {
                        InputCommand icd = (InputCommand)se;
                        string? nt;
                        if (myProcessor.ProcessMetaCommand(icd, out nt, rr))
                        {
                            //if (nt != null)
                                //EntryText.Text = nt;
                            continue;
                        }
                        
                        List<double> lve = new List<double>();
                        int l = myItems.Count;
                        List<CommandSE> lse = myProcessor.UnpackInput(icd, myItems, l);
                        int j = lse.Count;
                        for (int i=0; i<j; i++)
                        {
                            CommandSE cse = lse[i];
                            double cso = myProcessor.ProcessCmd(myItems, myItems.Values, cse);
                            lve.Add(cso);
                        }
                        for (int i = 0; i < j; i++)
                        {
                            myItems.AddToStack(lse[i], lve[i], rr + i);
                        }
                    }
                }
                catch (Exception x)
                {
                    ErrorSE ese = new ErrorSE() { TypedEntry = li, Comment = x.Message, myException = x };
                    myItems.AddToStack(ese, null, rr);
                }
                lineswritten++;
                Console.CursorLeft = layout_indices[1];
            }
        }

        public static void ClearLine(int ln)
        {
            if (ln < 0 || ln >= Console.BufferHeight)
                return;
            Console.SetCursorPosition(0, ln);
            for (int i = 0; i < Console.BufferWidth; i++)
                Console.Write(' ');
        }
    }
}