﻿using System.ComponentModel;

namespace MCalcConsole
{
    internal abstract class StackEntry : INotifyPropertyChanged
    {
        public string? TypedEntry
        {
            get { return _typedEntry; }
            set
            {
                _typedEntry = value; PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("TypedEntry"));
                //else { throw new Exception("Cannot modify typed entry"); }
            }
        }
        string? _typedEntry;
        public double? Result
        {
            get { return _result; }
            set
            {
                _result = value; PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("Result"));
                //else { throw new Exception("Cannot modify result"); }
            }
        }
        double? _result;
        public string? Comment
        {
            get { return _comment; }
            set
            {
                _comment = value; PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("Comment"));
            }
        }
        string? _comment;
        public string AR
        {
            get { return _AR; }
            set { _AR = value; PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("AR")); }
        }
        string? _AR;
        public event PropertyChangedEventHandler? PropertyChanged;
    }

    internal class ErrorSE : StackEntry
    {
        public Exception? myException;
    }

    internal class CommentSE : StackEntry
    {

    }

    internal class ValueSE : StackEntry
    {
        
    }

    internal class CommandSE : StackEntry
    {
        internal List<SRSingle>? cmdrefs;
        internal required string cmdword;
        internal int mlin, mlout, prefs;
    }

    internal class RenumberSE : StackEntry {
        internal int newStart;
    }

    internal class InputCommand : StackEntry
    {
        internal List<StackReference>? cmdrefs;
        internal required string cmdword;
        internal int prefs = 0;
    }
}
