﻿namespace MCalcConsole
{
    internal class ExtCmdManager
    {
        public SortedSet<string> AvailableCommands = new SortedSet<string>();
        public SortedList<string, ExtCmdProps> LoadedCommands = new SortedList<string, ExtCmdProps>();
        public string ExtCmdsDir = "./extcmds";

        public ExtCmdManager()
        {
            if (!Directory.Exists(ExtCmdsDir))
                return;
            IEnumerable<string> fls = Directory.EnumerateFiles(ExtCmdsDir, "*.txt");
            foreach(string fn in fls)
            {
                string f = Path.GetFileNameWithoutExtension(fn);
                bool v = f.Length > 0;
                for(int i=0; i<f.Length; i++)
                {
                    if (f[i] < 'a' || f[i] > 'z')
                    {
                        if (!(f[i] >= '0' && f[i] <= '9' && i > 0))
                        {
                            v = false;
                            break;
                        }
                    }
                }
                if (v)
                {
                    AvailableCommands.Add(f);
                }
            }
        }

        public void LoadCommand(string cmd)
        {
            string fn = Path.Combine(ExtCmdsDir, cmd + ".txt");
            string[] clines = File.ReadAllLines(fn);
            StackEntries cmdStack = new StackEntries();
            Parser myParser = new Parser() { myStack = cmdStack };
            int il = 0, ol = 0;
            for (int i=0; i<clines.Length; i++)
            {
                StackEntry se = myParser.ParseInput(clines[i]);
                if (se is InputCommand) {
                    InputCommand cse = ((InputCommand)se);
                    if (cse.cmdword == Processor.ei_cmd)
                        il++;
                    if(cse.cmdword == Processor.eo_cmd)
                    {
                        if (cse.cmdrefs != null && cse.cmdrefs.Count > 0)
                            ol += cse.cmdrefs.Count;
                        else
                            ol++;
                    }
                    if(cse.cmdword == Processor.ve_cmd || cse.cmdword == Processor.vc_cmd)
                        throw new Exception(cse.cmdword + " command in external commands is not supported");
                    List<SRSingle>? cr = null;
                    if (cse.cmdrefs != null && cse.cmdrefs.Count > 0)
                    {
                        cr = new List<SRSingle>();
                        foreach(StackReference sr in cse.cmdrefs)
                        {
                            if (sr is SRSingle)
                            {
                                if (((SRSingle)sr).stackIndex >= i)
                                    throw new Exception("Future references are not supported");
                                cr.Add((SRSingle)sr);
                            }
                            else
                                throw new Exception("Iterators in external commands are not supported");
                        }
                    }
                    se = new CommandSE() { cmdword = cse.cmdword, cmdrefs = cr };
                }
                cmdStack.AddToStack(se);
            }
            if (ol < 1)
                throw new Exception("External command produces no outputs");
            ExtCmdProps ecp = new ExtCmdProps() { inlines = il, outlines = ol, myStack = cmdStack };
            LoadedCommands.Add(cmd, ecp);
        }
    }

    internal class ExtCmdProps
    {
        //internal delegate double[] ComputeResult(List<double> args);
        required public int inlines, outlines;
        required public StackEntries myStack;
        //required public ComputeResult cmdfunc;
    }
}
