﻿using SciChart.Charting.Model.DataSeries;
using SciChart.Data.Model;
using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Threading;

namespace ECGDisplay
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {

        BCIBoard myBoard;
        InterfaceBCISerial mySerialInterface;
        ControlBCI myControlBCI;

        List<IBCIListener> BCIListeners;

        int packetsCtr = 0;

        public MainWindow()
        {
            InitializeComponent();

            string[] pn = SerialPort.GetPortNames();
            if (pn.Count() == 0)
            {
                MessageBox.Show("No COM ports found!", "Serial Error 1", MessageBoxButton.OK, MessageBoxImage.Exclamation);
                return;
            }

            foreach(string p in pn)
            {
                COMPortBox.Items.Add(p);
                COMPortBox.IsEnabled = true;
            }

            BCIListeners = new List<IBCIListener>();
        }

        private void COMPortBox_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            string p = (string)e.AddedItems[0];
            myBoard = new BCIBoard();

            mySerialInterface = new InterfaceBCISerial(myBoard, p, SerialDataReceived);

            COMPortBox.IsEnabled = false;
            
            myControlBCI = new ControlBCI(myBoard, mySerialInterface);
            myControlBCI.Show();
            
            BCIListeners.Add(new ControlPlotter());
            //BCIListeners.Add(new ControlFFT(4, myBoard.dataRate, BCIChannel.Number.c4));
            //BCIListeners.Add(new SleepTracker());

            foreach(IBCIListener lis in BCIListeners)
            {
                lis.Initialize();
            }
            
            StartBtn.IsEnabled = true;
        }

        private void StartBtn_Click(object sender, RoutedEventArgs e)
        {
            StartBtn.IsEnabled = false;
            StopBtn.IsEnabled = true;
            mySerialInterface.StartData();
        }

        private void StopBtn_Click(object sender, RoutedEventArgs e)
        {
            StopBtn.IsEnabled = false;
            StartBtn.IsEnabled = true;
            mySerialInterface.StopData();
        }

        private void StoreBtn_Click(object sender, RoutedEventArgs e)
        {
            //
        }

        private void ClearBtn_Click(object sender, RoutedEventArgs e)
        {
            //MessageBox.Show("Missed packets: " + mySerialInterface.ToString() + "\nGood packets: " + goodPacketsCounter.ToString() + "\nBad packets: " + badPacketsCounter.ToString());
        }

        private void PlotterBtn_Click(object sender, RoutedEventArgs e)
        {
            //
        }

        private void ConfigureBtn_Click(object sender, RoutedEventArgs e)
        {
            //comPort.Write("x1160000Xx2160000Xx3160000Xx4040100Xx5160000Xx6160000Xx7160000Xx8160000X");
            //configure all channels except 4 to be OFF, Gain=24x, Input=Normal, Exclude bias, Exclude SRB2, Exclude SRB1
            //configure channel 4 to be ON, Gain=8x, Input=Normal, Include bias, Exclude SRB2, Exclude SRB1

            //comPort.WriteLine("C1c001"); //configure ch1 to be on and connected to internal test signal at 1x gain
            //comPort.Write("T10"); //configure test signal to be 0.975 Hz and 1.875 mV
            //comPort.WriteLine("T21"); //configure test signal to be 1.95 Hz and 3.75 mV
        }

        public void SerialDataReceived(BCIPacket pk)
        {
            foreach (IBCIListener lis in BCIListeners)
            {
                lis.AnalyzePacket(pk);
            }
            packetsCtr++;
            if(packetsCtr % 250 == 0)
            {
                this.Dispatcher.Invoke(() => { DisplaySerialStats(); });
            }
        }

        void DisplaySerialStats()
        {
            CorrectPksText.Text = mySerialInterface.correctPacketsCounter.ToString();
            CorrectedPksText.Text = mySerialInterface.correctedPacketsCounter.ToString();
            CorrectedBitsText.Text = mySerialInterface.correctedBitsCounter.ToString();
            UncorrPksText.Text = mySerialInterface.uncorrectablePacketsCounter.ToString();
            UncorrBitsText.Text = mySerialInterface.uncorrectableBitsCounter.ToString();
            MissedPksText.Text = mySerialInterface.missedPacketsCounter.ToString();
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            if(mySerialInterface != null && mySerialInterface.IsStreaming)
            {
                mySerialInterface.StopData();
            }

            if(myControlBCI != null)
            {
                myControlBCI.Close();
            }

            foreach (IBCIListener lis in BCIListeners)
            {
                lis.Shutdown();
            }
        }
    }
}
