﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace ECGDisplay
{
    /// <summary>
    /// Interaction logic for ControlBCI.xaml
    /// </summary>
    public partial class ControlBCI : Window
    {
        BCIBoard myBoard;
        InterfaceBCISerial myInterface;

        public ControlBCI(BCIBoard board, InterfaceBCISerial inter)
        {
            InitializeComponent();
            myBoard = board;
            myInterface = inter;
            this.DataContext = board;
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            BCIChannel ch = myBoard.BoardChannels[1];
        }

        private void ChannelUpdateBtn_Click(object sender, RoutedEventArgs e)
        {
            Button b = (Button)sender;
            BCIChannel ch = (BCIChannel)b.Tag;

            myInterface.SetChannelProperties(ch);
        }

        private void DatarateUpdateBtn_Click(object sender, RoutedEventArgs e)
        {
            myInterface.SetDatarate();
        }

        private void PropsUpdateBtn_Click(object sender, RoutedEventArgs e)
        {
            myInterface.SetProps();
        }

        private void TestSignalUpdateBtn_Click(object sender, RoutedEventArgs e)
        {
            myInterface.SetTestSignal();
        }

        private void LeadOffSignalUpdateBtn_Click(object sender, RoutedEventArgs e)
        {
            myInterface.SetLeadOffSignal();
        }

        private void LeadOffChannelUpdateBtn_Click(object sender, RoutedEventArgs e)
        {
            myInterface.SetLeadOffChannels();
        }

        private void BiasGeneratorUpdateBtn_Click(object sender, RoutedEventArgs e)
        {
            myInterface.SetBiasgen();
        }

        private void ChannelSequenceUpdateBtn_Click(object sender, RoutedEventArgs e)
        {
            throw new NotImplementedException();
            myInterface.SetChSequence();
        }
    }
}
