﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Xml.Serialization;
using static PhotoArrange.CBoard;

namespace PhotoArrange
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        //Object select_object;
        CBImage adding_image;
        //CBLine new_line;
        //double move_xo, move_yo;

        CBoard myBoard;

        public MainWindow()
        {
            InitializeComponent();
            myBoard = new CBoard();
            myBoard.SetCanvas(MainCanvas);
        }

        private void MainCanvas_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
                if(adding_image != null && adding_image.Filepath == files[0])
                {
                    //restore previous outline (bug in .NET code results in this being called repeatedly)
                    //select_object = adding_image;
                    Point pos = e.GetPosition(MainCanvas);
                    adding_image.MoveOutline(pos);
                    adding_image.ShowOutline(true);
                    myBoard.dragMode = MouseMode.NewImage;
                }
                else //new file
                {
                    adding_image = new CBImage();
                    adding_image.PreloadFile(MainCanvas, files[0]);
                    Point pos = e.GetPosition(MainCanvas);
                    adding_image.MoveOutline(pos);
                    adding_image.ShowOutline(true);
                    myBoard.dragMode = MouseMode.NewImage;
                    //MainCanvas.CaptureMouse();
                }
                e.Handled = true;
            }
        }

        private void MainCanvas_DragLeave(object sender, DragEventArgs e)
        {
            e.Handled = true;
            if(adding_image != null)
            {
                adding_image.ShowOutline(false); //don't unload yet to save time with .NET bug
            }
            myBoard.dragMode = MouseMode.None;
        }

        private void MainCanvas_DragOver(object sender, DragEventArgs e)
        {
            if (myBoard.dragMode != MouseMode.NewImage)
                return;
            e.Handled = true;
            Point pos = e.GetPosition(MainCanvas);
            adding_image.MoveOutline(pos);
        }

        private void Canvas_Drop(object sender, DragEventArgs e)
        {
            // Handle FileDrop data.
            //Based on https://docs.microsoft.com/en-us/dotnet/api/system.windows.forms.control.allowdrop?view=windowsdesktop-5.0
            //if (sender != MainCanvas)
            //return;
            // If the data is a file or a bitmap, display the copy cursor.
            Point pos = e.GetPosition(MainCanvas);

            if (adding_image == null) //not preloaded
            {
                string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
                adding_image = new CBImage();
                adding_image.PreloadFile(MainCanvas, files[0]);
            }

            adding_image.FinishDrop(pos, myBoard);

            adding_image = null;

            myBoard.dragMode = MouseMode.None;
            e.Handled = true;
        }

        private void MainCanvas_MouseDown(object sender, MouseButtonEventArgs e)
        {
            if (myBoard.clickMode == Tools.Select)
            {
                e.Handled = true;
                myBoard.Deselect();
            }
        }

        private void MainCanvas_MouseUp(object sender, MouseButtonEventArgs e)
        {
            if (myBoard.dragMode == MouseMode.NewLineEnd)
            {
                e.Handled = true;
                myBoard.CancelNewLine();
            }

            if (myBoard.dragMode == MouseMode.DragImage)
            {
                e.Handled = true;
                myBoard.FinishDrag(e.GetPosition(MainCanvas));
            }
        }

        private void RadioButton_Click(object sender, RoutedEventArgs e)
        {
            RadioButton src = (RadioButton)sender;
            string fx = (string)src.Content;
            myBoard.Deselect();
            switch (fx)
            {
                case "Line":
                    myBoard.clickMode = Tools.Line;
                    break;
                case "Drag":
                    myBoard.clickMode = Tools.Drag;
                    break;
                case "Select":
                    myBoard.clickMode = Tools.Select;
                    break;
                case "None":
                    myBoard.clickMode = Tools.None;
                    break;
            }
        }

        private void MainCanvas_MouseMove(object sender, MouseEventArgs e)
        {
            if (myBoard.dragMode == MouseMode.NewLineEnd)
            {
                e.Handled = true;
                myBoard.PreviewNewLine(e.GetPosition(MainCanvas));
            }

            if(myBoard.dragMode == MouseMode.DragImage)
            {
                e.Handled = true;
                myBoard.PreviewDrag(e.GetPosition(MainCanvas));
            }
            /*if (dragMode == MouseMode.None)
                return;
            e.Handled = true;
            Point pos=e.GetPosition(MainCanvas);
            if (dragMode == MouseMode.DragImage || dragMode == MouseMode.NewImage)
            {
                Image src = (Image)select_object;
                ImageTag itg = (ImageTag)src.Tag;
                Canvas.SetLeft(itg.AttachedOutline, pos.X + move_xo - 1);
                Canvas.SetTop(itg.AttachedOutline, pos.Y + move_yo - 1);
            }
            if(dragMode == MouseMode.NewLineEnd)
            {
                new_line.X2 = pos.X;
                new_line.Y2 = pos.Y;
            }*/
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            Button src = (Button)sender;
            string fx = (string)src.Content;
           
            switch (fx)
            {
                case "Delete":
                    /*if (select_object != null)
                    {
                        if (select_object is Image)
                        {
                            //delete image
                            //delete lines
                            //delete references to lines in other images
                            Image src2 = (Image)select_object;
                            ImageTag itg2 = (ImageTag)src2.Tag;
                            foreach (Line ll in itg2.AttachedLines1)
                            {
                                LineTag ltg = (LineTag)ll.Tag;
                                Image src3 = ltg.AttachedImage2;
                                ImageTag itg3 = (ImageTag)src3.Tag;
                                itg3.AttachedLines2.Remove(ll);
                                MainCanvas.Children.Remove(ll);
                            }
                            foreach (Line ll in itg2.AttachedLines2)
                            {
                                LineTag ltg = (LineTag)ll.Tag;
                                Image src3 = ltg.AttachedImage1;
                                ImageTag itg3 = (ImageTag)src3.Tag;
                                itg3.AttachedLines1.Remove(ll);
                                MainCanvas.Children.Remove(ll);
                            }
                            MainCanvas.Children.Remove(src2);
                            MainCanvas.Children.Remove(itg2.AttachedOutline);
                        }
                        if (select_object is Line)
                        {
                            //delete lines
                            //delete references to lines in other images
                            Line ll = (Line)select_object;
                            LineTag ltg = (LineTag)ll.Tag;
                            Image src2 = ltg.AttachedImage1;
                            ImageTag itg2 = (ImageTag)src2.Tag;
                            itg2.AttachedLines1.Remove(ll);
                            Image src3 = ltg.AttachedImage2;
                            ImageTag itg3 = (ImageTag)src3.Tag;
                            itg3.AttachedLines2.Remove(ll);
                            MainCanvas.Children.Remove(ll);
                        }
                        select_object = null;
                    }*/
                    myBoard.DeleteSelected();
                    break;
                case "Save":
                    TextWriter writer = null;
                    string initDir;
                    string path;
                    if (myBoard.filepath == null)
                    {
                        initDir = Environment.GetFolderPath(Environment.SpecialFolder.MyPictures);
                        Microsoft.Win32.SaveFileDialog dlg = new Microsoft.Win32.SaveFileDialog();
                        dlg.DefaultExt = ".xml";
                        dlg.FileName = "board";
                        dlg.Filter = "XML Files (.xml)|*.xml";
                        dlg.InitialDirectory = initDir;

                        if (dlg.ShowDialog() != true)
                            return;

                        path = dlg.FileName;
                    }
                    else
                    {
                        path = myBoard.filepath;
                    }

                    try
                    {
                        myBoard.PrepareSaveXML(path);
                    }
                    catch (UriFormatException x)
                    {
                        System.Windows.MessageBox.Show("Save error: " + x.Message);
                        return;
                    }

                    try
                    {
                        var serializer = new XmlSerializer(typeof(CBoard));
                        writer = new StreamWriter(myBoard.filepath, false);
                        serializer.Serialize(writer, myBoard);
                        System.Windows.MessageBox.Show("Saved to " + myBoard.filepath);
                    }
                    finally
                    {
                        if (writer != null)
                            writer.Close();
                    }
                    break;
                case "Load":
                    TextReader reader = null;
                    string initDir2;
                    if (myBoard.filepath == null)
                    {
                        initDir2 = Environment.GetFolderPath(Environment.SpecialFolder.MyPictures);
                    }
                    else
                    {
                        initDir2 = System.IO.Path.GetDirectoryName(myBoard.filepath);
                    }

                    Microsoft.Win32.OpenFileDialog dlg2 = new Microsoft.Win32.OpenFileDialog();
                    dlg2.DefaultExt = ".xml";
                    dlg2.FileName = "board";
                    dlg2.Filter = "XML Files (.xml)|*.xml";
                    dlg2.InitialDirectory = initDir2;

                    if (dlg2.ShowDialog() != true)
                        return;
                    string path2 = dlg2.FileName;
                    try
                    {
                        CleanSlate();
                        var serializer = new XmlSerializer(typeof(CBoard));
                        reader = new StreamReader(path2);
                        myBoard=(CBoard)serializer.Deserialize(reader);
                        myBoard.LoadFromXML(MainCanvas, path2);
                    }
                    finally
                    {
                        if (reader != null)
                            reader.Close();
                    }
                    break;
                case "New":
                    CleanSlate();
                    myBoard = new CBoard();
                    myBoard.SetCanvas(MainCanvas);
                    break;
                case "Zoom In":
                    CanvasZoom.ScaleX *= 1.1;
                    CanvasZoom.ScaleY *= 1.1;
                    break;
                case "Zoom Out":
                    CanvasZoom.ScaleX /= 1.1;
                    CanvasZoom.ScaleY /= 1.1;
                    break;
                case "Zoom Orig":
                    CanvasZoom.ScaleX = 1;
                    CanvasZoom.ScaleY = 1;
                    break;
                case "Add Rgt":
                    MainCanvas.Width += 500;
                    break;
                case "Add Btm":
                    MainCanvas.Height += 500;
                    break;
                case "(+)":
                    if (myBoard.selectedObject is CBImage)
                        ((CBImage)myBoard.selectedObject).Zoom *= 1.1;
                    break;
                case "(-)":
                    if (myBoard.selectedObject is CBImage)
                        ((CBImage)myBoard.selectedObject).Zoom /= 1.1;
                    break;
                case "(Orig)":
                    if (myBoard.selectedObject is CBImage)
                        ((CBImage)myBoard.selectedObject).Zoom = 1;
                    break;
                case "(T+)":
                    if (myBoard.selectedObject is CBImage)
                        ((CBImage)myBoard.selectedObject).OThick++;
                    if (myBoard.selectedObject is CBLine)
                        ((CBLine)myBoard.selectedObject).Thick++;
                    break;
                case "(T-)":
                    if (myBoard.selectedObject is CBImage)
                        ((CBImage)myBoard.selectedObject).OThick--;
                    if (myBoard.selectedObject is CBLine)
                        ((CBLine)myBoard.selectedObject).Thick--;
                    break;
                case "MDef":
                    if (myBoard.selectedObject is CBImage)
                        ((CBImage)myBoard.selectedObject).MakeDefault();
                    if (myBoard.selectedObject is CBLine)
                        ((CBLine)myBoard.selectedObject).MakeDefault();
                    break;
            }
        }

        private void Color_Btn_Click(object sender, RoutedEventArgs e)
        {
            Button s = (Button)sender;
            Rectangle r = (Rectangle)s.Content;
            BrushConverter bc = new BrushConverter();
            string color = bc.ConvertToString(r.Fill);
            if (myBoard.selectedObject is CBImage)
                ((CBImage)myBoard.selectedObject).OColor = color;
            if (myBoard.selectedObject is CBLine)
                ((CBLine)myBoard.selectedObject).Color = color;
        }

        private void CheckBox_Click(object sender, RoutedEventArgs e)
        {
            CheckBox src = (CheckBox)sender;
            string fx = (string)src.Content;

            switch (fx)
            {
                case "LF":
                    myBoard.LineFollowsImg1 = (src.IsChecked == true);
                    break;
                case "LC":
                    myBoard.LineCarriesImg1 = (src.IsChecked == true);
                    break;
            }
        }

        private void CleanSlate()
        {
            myBoard.Unload();
            MainCanvas.Children.Clear();
            ToolNone.IsChecked = true;
            LFCheck.IsChecked = false;
            LCCheck.IsChecked = false;
            CanvasZoom.ScaleX = 1;
            CanvasZoom.ScaleY = 1;
        }
    }
}
