﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Shapes;

namespace PhotoArrange
{
    public class CBLine
    {
        public int Node1 { get { return myBoard.nodes.IndexOf(AttachedImage1); } set { if (myBoard != null) AttachedImage1 = myBoard.nodes[value]; else tempInd1 = value; } }
        public int Node2 { get { return myBoard.nodes.IndexOf(AttachedImage2); } set { if (myBoard != null) AttachedImage2 = myBoard.nodes[value]; else tempInd2 = value; } }
        private int tempInd1 = 0, tempInd2 = 0;
        protected CBImage AttachedImage1;
        protected CBImage AttachedImage2;
        public string comment;
        private CBoard myBoard;
        private Canvas myCanvas;
        private Line myLine;
        private bool lineAdded = false;
        private static Color DefaultOutlineColor = CBoard.DefaultColorAbs;
        private Color OutlineColor = DefaultOutlineColor;
        public string Color
        {
            get
            {
                return OutlineColor.ToString();
            }
            set
            {
                if (value is null)
                    OutlineColor = DefaultOutlineColor;
                else
                    OutlineColor = (Color)ColorConverter.ConvertFromString(value);
                if (myLine != null)
                    MarkSelected(false); //apply the new color
            }
        }
        public bool ShouldSerializeColor()
        {
            return OutlineColor != CBoard.DefaultColorAbs;
        }
        private static double DefaultThickness = CBoard.DefaultThicknessAbs;
        private double tempThick = DefaultThickness;
        public double Thick
        {
            get
            {
                if (myLine is null)
                    return tempThick;
                else
                    return myLine.StrokeThickness;
            }
            set
            {
                if (myLine is null)
                    tempThick = value;
                else
                {
                    myLine.StrokeThickness = value;
                }
            }
        }
        public bool ShouldSerializeThick()
        {
            return Thick != CBoard.DefaultThicknessAbs;
        }

        public static void ResetDefaults()
        {
            DefaultThickness = CBoard.DefaultThicknessAbs;
            DefaultOutlineColor = CBoard.DefaultColorAbs;
        }

        public void StartNewLine(Canvas canv, CBoard brd, CBImage img1, Point pos)
        {
            myCanvas = canv;
            myBoard = brd;

            if (myBoard.LineFollowsImg1)
                Color = img1.OColor;
            else
                Color = null;
            myLine = new Line();
            //myLine.Stroke = Brushes.Red;
            //OutlineColor = DefaultOutlineColor;
            MarkSelected(true);
            if (myBoard.LineFollowsImg1)
                Thick = img1.OThick;
            else
                Thick = DefaultThickness;
            Canvas.SetZIndex(myLine, -10);
            
            AttachedImage1 = img1;
            img1.FixLineEnd(true, this); //fix the end point 1 (without yet adding it to list, in case it will later be deleted)
            myLine.X2 = pos.X;
            myLine.Y2 = pos.Y; //temporary end point 2

            ShowLine(true);
        }

        public bool CheckDuplicateNew(CBImage img2)
        {
            return img2.CheckDuplicateLine(AttachedImage1);
        }

        public void FinishNewLine(CBImage img2)
        {
            AttachedImage2 = img2;
            //img2.FixLineEnd(false, this); - called in image class
            AttachedImage1.AddLine(true, this);
            AttachedImage2.AddLine(false, this);
            if (myBoard.LineCarriesImg1)
            {
                AttachedImage2.OColor = AttachedImage1.OColor;
                AttachedImage2.OThick = AttachedImage1.OThick;
            }
            MarkSelected(false);
            myLine.MouseDown += Line_MouseDown;
        }

        public bool CheckDuplicateImg(bool pt1, CBImage cbi)
        {
            if (pt1)
                return AttachedImage1 == cbi;
            else
                return AttachedImage2 == cbi;
        }

        public void MarkSelected(bool yes)
        {
            if(yes)
                myLine.Stroke = Brushes.Red;
            else
                myLine.Stroke = new SolidColorBrush(OutlineColor);
        }

        public void MakeDefault()
        {
            DefaultOutlineColor = OutlineColor;
            DefaultThickness = Thick;
        }

        public void MoveEnd(bool pt1, double x, double y)
        {
            if (pt1)
            {
                myLine.X1 = x;
                myLine.Y1 = y;
            }
            else
            {
                myLine.X2 = x;
                myLine.Y2 = y;
            }
        }

        public void ShowLine(bool show)
        {
            if (show && !lineAdded)
                myCanvas.Children.Add(myLine);
            if (!show && lineAdded)
                myCanvas.Children.Remove(myLine);
            lineAdded = show;
        }

        public void LoadFromXML(Canvas canv, CBoard nboard)
        {
            //the public elements are already loaded, now get the rest
            //this requires the images to already be loaded
            myCanvas = canv;
            myLine = new Line();
            //myLine.Stroke = Brushes.Black;
            MarkSelected(false);
            myLine.StrokeThickness = tempThick;
            Canvas.SetZIndex(myLine, -10);

            myBoard = nboard;
            AttachedImage1 = myBoard.nodes[tempInd1];
            AttachedImage2 = myBoard.nodes[tempInd2];
            AttachedImage1.AddLine(true, this); //given image is loaded, this adjusts line X1 and Y1 to the appropriate point by calling MoveEnd()
            AttachedImage2.AddLine(false, this);

            myLine.MouseDown += Line_MouseDown;
            ShowLine(true);
        }

        private void Line_MouseDown(object sender, MouseButtonEventArgs e)
        {
            if (myBoard.clickMode == CBoard.Tools.Select)
            {
                e.Handled = true;
                myBoard.Select(this);
            }
        }

        public void Delete()
        {
            //delete lines
            //delete references to lines in other images
            //Line ll = (Line)select_object;
            //LineTag ltg = (LineTag)ll.Tag;
            //Image src2 = ltg.AttachedImage1;
            //ImageTag itg2 = (ImageTag)src2.Tag;
            //itg2.AttachedLines1.Remove(ll);
            AttachedImage1.RemoveLine(true, this);
            AttachedImage2.RemoveLine(false, this);
            ShowLine(false);
            //Image src3 = ltg.AttachedImage2;
            //ImageTag itg3 = (ImageTag)src3.Tag;
            //itg3.AttachedLines2.Remove(ll);
            //MainCanvas.Children.Remove(ll);
        }

        public void Delete(bool pt1)
        {
            //delete lines
            //delete references to lines in other images
            //Line ll = (Line)select_object;
            //LineTag ltg = (LineTag)ll.Tag;
            //Image src2 = ltg.AttachedImage1;
            //ImageTag itg2 = (ImageTag)src2.Tag;
            //itg2.AttachedLines1.Remove(ll);
            if(pt1)
                AttachedImage1.RemoveLine(true, this);
            else
                AttachedImage2.RemoveLine(false, this);
            ShowLine(false);
            //Image src3 = ltg.AttachedImage2;
            //ImageTag itg3 = (ImageTag)src3.Tag;
            //itg3.AttachedLines2.Remove(ll);
            //MainCanvas.Children.Remove(ll);
        }
    }
}
