﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Xml.Serialization;
//using static PhotoArrange.CBoard;

namespace PhotoArrange
{
    public class CBImage
    {
        private List<CBLine> AttachedLines2;
        private List<CBLine> AttachedLines1;
        private Rectangle myOutline;
        private Image myImage;
        private Canvas myCanvas;
        private CBoard myBoard;
        private bool outlineAdded = false;
        private bool imageAdded = false;
        private double move_xo = 0, move_yo = 0;
        public double X { get { return Canvas.GetLeft(myImage); } set { if (myImage != null) Canvas.SetLeft(myImage, value); else move_xo = value; } }
        public double Y { get { return Canvas.GetTop(myImage); } set { if (myImage != null) Canvas.SetTop(myImage, value); else move_yo = value; } }
        public string filename; //partial path that will be saved in XML
        public string Filepath { get { return filepath; } }
        private string filepath;//full path used to load image
        public string comment;
        private static double DefaultZoom = CBoard.DefaultZoomAbs;
        private double tempZoom = DefaultZoom;
        public double Zoom
        {
            get
            {
                if (myImage is null || myImage.RenderTransform is null)
                    return tempZoom;
                else
                    return ((ScaleTransform)myImage.RenderTransform).ScaleX;
            }
            set
            {
                if (myImage is null || myImage.RenderTransform is null)
                    tempZoom = value;
                else
                {
                    ((ScaleTransform)myImage.RenderTransform).ScaleX = value;
                    ((ScaleTransform)myImage.RenderTransform).ScaleY = value;
                    myOutline.Width = myImage.Source.Width * value + 2 * myOutline.StrokeThickness;
                    myOutline.Height = myImage.Source.Height * value + 2 * myOutline.StrokeThickness;
                    RelocateLines();
                }
            }
        }
        public bool ShouldSerializeZoom() { return Zoom != CBoard.DefaultZoomAbs; }
        private static Color DefaultOutlineColor = CBoard.DefaultColorAbs;
        private Color OutlineColor = DefaultOutlineColor;
        public string OColor
        {
            get
            {
                return OutlineColor.ToString();
            }
            set
            {
                if (value is null)
                    OutlineColor = DefaultOutlineColor;
                else
                    OutlineColor = (Color)ColorConverter.ConvertFromString(value);
                if (myOutline != null)
                    MarkSelected(false); //apply the new color
            }
        }
        public bool ShouldSerializeOColor()
        {
            return (OutlineColor != CBoard.DefaultColorAbs);
        }
        
        private static double DefaultThickness = CBoard.DefaultThicknessAbs;
        private double tempThick = DefaultThickness;
        public double OThick {
            get
            {
                if (myOutline is null)
                    return tempThick;
                else
                    return myOutline.StrokeThickness;
            }
            set
            {
                if (myOutline is null)
                    tempThick = value;
                else
                {
                    myOutline.StrokeThickness = value;
                    myOutline.Width = myImage.Source.Width * Zoom + 2 * myOutline.StrokeThickness;
                    myOutline.Height = myImage.Source.Height * Zoom + 2 * myOutline.StrokeThickness;
                    Canvas.SetLeft(myOutline, Canvas.GetLeft(myImage) - myOutline.StrokeThickness);
                    Canvas.SetTop(myOutline, Canvas.GetTop(myImage) - myOutline.StrokeThickness);
                }
            }
        }
        public bool ShouldSerializeOThick()
        {
            return OThick != CBoard.DefaultThicknessAbs;
        }

        public static void ResetDefaults()
        {
            DefaultThickness = CBoard.DefaultThicknessAbs;
            DefaultOutlineColor = CBoard.DefaultColorAbs;
            DefaultZoom = CBoard.DefaultZoomAbs;
        }

        public CBImage()
        {
            AttachedLines1 = new List<CBLine>();
            AttachedLines2 = new List<CBLine>();
            myOutline = null;
        }

        public void MakeDefault()
        {
            DefaultOutlineColor = OutlineColor;
            DefaultThickness = OThick;
        }

        public void PreloadFile(Canvas canv, string path)
        {
            myCanvas = canv;
            myImage = new Image();
            filepath = path;
            myImage.Source = new BitmapImage(new Uri(filepath));
            myOutline = new Rectangle();
            //myOutline.Stroke = Brushes.Red;
            //OutlineColor = Colors.Black;
            MarkSelected(true);
            myOutline.StrokeThickness = DefaultThickness;
            myOutline.Width = myImage.Source.Width * tempZoom + 2 * myOutline.StrokeThickness;
            myOutline.Height = myImage.Source.Height * tempZoom + 2 * myOutline.StrokeThickness;
            move_xo = -myImage.Source.Width * tempZoom / 2;
            move_yo = -myImage.Source.Height * tempZoom / 2;
            Canvas.SetZIndex(myOutline, -5);
        }

        public void ShowOutline(bool show)
        {
            if(show && !outlineAdded)
                myCanvas.Children.Add(myOutline);
            if (!show && outlineAdded)
                myCanvas.Children.Remove(myOutline);
            outlineAdded = show;
        }

        public void MoveOutline(Point pos)
        {
            Canvas.SetLeft(myOutline, pos.X + move_xo - myOutline.StrokeThickness);
            Canvas.SetTop(myOutline, pos.Y + move_yo - myOutline.StrokeThickness);
        }

        public void ShowImage(bool show)
        {
            if (show && !imageAdded)
                myCanvas.Children.Add(myImage);
            if (!show && imageAdded)
                myCanvas.Children.Remove(myImage);
            imageAdded = show;
        }

        public void MoveImage(Point pos)
        {
            Canvas.SetLeft(myImage, pos.X + move_xo);
            Canvas.SetTop(myImage, pos.Y + move_yo);
        }

        public bool CheckDuplicateLine(CBImage cbi)
        {
            foreach (CBLine cbl in AttachedLines1)
                if (cbl.CheckDuplicateImg(false, cbi))
                    return true;
            foreach (CBLine cbl in AttachedLines2)
                if (cbl.CheckDuplicateImg(true, cbi))
                    return true;
            return false;
        }

        public void AddLine(bool pt1, CBLine ln)
        {
            FixLineEnd(pt1, ln); //for sanity
            if (pt1)
            {
                AttachedLines1.Add(ln);
            }
            else
            {
                AttachedLines2.Add(ln);
            }
        }

        public void RemoveLine(bool pt1, CBLine ln)
        {
            //FixLineEnd(pt1, ln); //for sanity
            if (pt1)
            {
                AttachedLines1.Remove(ln);
            }
            else
            {
                AttachedLines2.Remove(ln);
            }
        }

        public void FixLineEnd(bool pt1, CBLine ln)
        {
            if (pt1)
            {
                ln.MoveEnd(true, Canvas.GetLeft(myImage) + (myImage.Source.Width * Zoom / 2), Canvas.GetTop(myImage) + (myImage.Source.Height * Zoom / 2));
            }
            else
            {
                ln.MoveEnd(false, Canvas.GetLeft(myImage) + (myImage.Source.Width * Zoom / 2), Canvas.GetTop(myImage) + (myImage.Source.Height * Zoom / 2));
            }
        }

        public void RelocateLines()
        {
            foreach (CBLine ll in AttachedLines1)
            {
                FixLineEnd(true, ll);
            }
            foreach (CBLine ll in AttachedLines2)
            {
                FixLineEnd(false, ll);
            }
        }
        
        public void FinishDrop(Point pos, CBoard nboard)
        {
            MoveOutline(pos);
            MarkSelected(false);
            ShowOutline(true);
            MoveImage(pos);
            ShowImage(true);
            //MoveLines(pos); - no lines for a new image

            myImage.MouseDown += Img_MouseDown;
            myImage.MouseUp += Img_MouseUp;
            myImage.MouseEnter += Img_MouseEnter;
            myImage.MouseLeave += Img_MouseLeave;
            //myImage.MouseMove += Img_MouseMove;

            myImage.RenderTransform = new ScaleTransform(tempZoom, tempZoom);

            move_xo = 0;
            move_yo = 0;

            myBoard = nboard;
            myBoard.nodes.Add(this);
        }

        public void MarkSelected(bool yes)
        {
            if (yes)
                myOutline.Stroke = Brushes.Red;
            else
                myOutline.Stroke = new SolidColorBrush(OutlineColor);
        }

        public void ReferenceFilename(string dirStart)
        {
            if (!filepath.StartsWith(dirStart))
                throw new UriFormatException("An image was not in the save directory, which is required for relative path saving: " + filepath);
            filename = filepath.Substring(dirStart.Length);
        }

        public void LoadFromXML(Canvas canv, CBoard nboard, string dirStart)
        {
            //the public elements are already loaded, now get the rest
            myCanvas = canv;
            myImage = new Image();
            filepath = dirStart + filename;
            myImage.Source = new BitmapImage(new Uri(filepath));
            myImage.RenderTransform = new ScaleTransform(tempZoom, tempZoom);
            myOutline = new Rectangle();
            //if (OutlineColor == null)
                //OutlineColor = Colors.Black;
            //myOutline.Stroke = Brushes.Black;
            //myOutline.Stroke = new SolidColorBrush(OutlineColor);
            MarkSelected(false);
            myOutline.StrokeThickness = tempThick;
            myOutline.Width = myImage.Source.Width * tempZoom + 2 * myOutline.StrokeThickness;
            myOutline.Height = myImage.Source.Height * tempZoom + 2 * myOutline.StrokeThickness;
            Canvas.SetZIndex(myOutline, -5);

            Canvas.SetLeft(myImage, move_xo);
            Canvas.SetTop(myImage, move_yo);
            Canvas.SetLeft(myOutline, move_xo - myOutline.StrokeThickness);
            Canvas.SetTop(myOutline, move_yo - myOutline.StrokeThickness);

            move_xo = 0;
            move_yo = 0;

            myImage.MouseDown += Img_MouseDown;
            myImage.MouseUp += Img_MouseUp;
            myImage.MouseEnter += Img_MouseEnter;
            myImage.MouseLeave += Img_MouseLeave;
            //myImage.MouseMove += Img_MouseMove;

            ShowOutline(true);
            ShowImage(true);

            myBoard = nboard; //(this) is already included in the board nodes
            //lines will be loaded separately
        }
           /* move_xo = -(adding_image.Source.Width / 2);
            move_yo = -(adding_image.Source.Height / 2);
            Canvas.SetLeft(outline, pos.X + move_xo - 1);
            Canvas.SetTop(outline, pos.Y + move_yo - 1);
            Canvas.SetZIndex(outline, -5);
            MainCanvas.Children.Add(outline);
            itg.AttachedOutline = outline;
            adding_image.Tag = itg;
            dragMode = MouseMode.NewImage;

            ImageTag itg = new ImageTag();
            itg.filename = files[0];
            select_object = adding_image;
            Point pos = e.GetPosition(MainCanvas);
            Rectangle outline = new Rectangle();
            outline.Stroke = Brushes.Red;
            outline.StrokeThickness = 1;
            outline.Width = adding_image.Source.Width + 2;
            outline.Height = adding_image.Source.Height + 2;
            move_xo = -(adding_image.Source.Width / 2);
            move_yo = -(adding_image.Source.Height / 2);
            Canvas.SetLeft(outline, pos.X + move_xo - 1);
            Canvas.SetTop(outline, pos.Y + move_yo - 1);
            Canvas.SetZIndex(outline, -5);
            MainCanvas.Children.Add(outline);
            itg.AttachedOutline = outline;
            adding_image.Tag = itg;
            dragMode = MouseMode.NewImage;
        }*/

        private void Img_MouseEnter(object sender, MouseEventArgs e)
        {
            if (myBoard.dragMode != CBoard.MouseMode.NewLineEnd)
                return;
            e.Handled = true;
            if (this == myBoard.selectedObject)
                return; //avoid changing color of start point
            myOutline.Stroke = Brushes.Green;
            /*if (sender == select_object)
                return; //avoid changing color of start point
            CBImage src = (CBImage)sender;
            src.myOutline.Stroke = Brushes.Green;*/
        }

        private void Img_MouseLeave(object sender, MouseEventArgs e)
        {
            if (myBoard.dragMode != CBoard.MouseMode.NewLineEnd)
                return;
            e.Handled = true;
            if (this == myBoard.selectedObject)
                return; //avoid changing color of start point
            /*if (sender == select_object)
                return; //avoid changing color of start point
            Image src = (Image)sender;
            ImageTag itg = (ImageTag)src.Tag;
            itg.AttachedOutline.Stroke = Brushes.Black;*/
            //myOutline.Stroke = Brushes.Black;
            MarkSelected(false);
        }

        private void Img_MouseDown(object sender, MouseButtonEventArgs e)
        {
            if (myBoard.dragMode != CBoard.MouseMode.None || myBoard.clickMode == CBoard.Tools.None)
                return;

            e.Handled = true;
            Point pt = e.GetPosition(myCanvas);

            switch (myBoard.clickMode)
            {
                case CBoard.Tools.Select:
                    myBoard.Select(this);
                    break;
                case CBoard.Tools.Line:
                    myBoard.StartNewLine(this, pt);
                    break;
                case CBoard.Tools.Drag:
                    myBoard.Select(this);
                    move_xo = Canvas.GetLeft(myImage) - pt.X;
                    move_yo = Canvas.GetTop(myImage) - pt.Y;
                    myBoard.dragMode = CBoard.MouseMode.DragImage;
                    break;
            }
        }

        /*private void Img_MouseMove(object sender, MouseEventArgs e)
        {
            if (myBoard.dragMode != MouseMode.DragImage || myBoard.selectedObject != this)
                return;
            e.Handled = true;
            Point pos=e.GetPosition(myCanvas);
            //if (myBoard.dragMode == MouseMode.DragImage)
            //{
                MoveOutline(pos);
                //Canvas.SetLeft(myOutline, pos.X + move_xo - myOutline.StrokeThickness);
                //Canvas.SetTop(myOutline, pos.Y + move_yo - myOutline.StrokeThickness);
            //}
            /*if(dragMode == MouseMode.NewLineEnd)
            {
                new_line.X2 = pos.X;
                new_line.Y2 = pos.Y;
            }*/
        //}

        private void Img_MouseUp(object sender, MouseButtonEventArgs e)
        {
            if (myBoard.dragMode != CBoard.MouseMode.NewLineEnd)
                return;
            e.Handled = true;

            Point pos = e.GetPosition(myCanvas);

            //if (myBoard.dragMode == CBoard.MouseMode.NewLineEnd)
            //{
                if (this == myBoard.selectedObject)
                {
                    //no line to be made
                    myBoard.CancelNewLine();
                }
                else
                {
                    //myOutline.Stroke = Brushes.Black;
                    MarkSelected(false);
                    myBoard.FinishNewLine(this);
                }
                /*if (sender == select_object) //avoid making redundant lines
                {
                    MainCanvas.Children.Remove(new_line);
                    new_line = null;
                    src = (Image)select_object;
                    ImageTag itg = (ImageTag)src.Tag;
                    itg.AttachedOutline.Stroke = Brushes.Black;
                    select_object = null;
                    dragMode = MouseMode.None;
                }
                else
                {
                    src = (Image)sender;
                    new_line.X2 = Canvas.GetLeft(src) + src.Source.Width / 2;
                    new_line.Y2 = Canvas.GetTop(src) + src.Source.Height / 2;
                    new_line.Stroke = Brushes.Black;
                    new_line.MouseDown += Line_MouseDown;
                    Image orig = (Image)select_object;
                    ImageTag origtag = (ImageTag)orig.Tag;
                    origtag.AttachedLines1.Add(new_line);
                    ImageTag itg = (ImageTag)src.Tag;
                    itg.AttachedLines2.Add(new_line);
                    LineTag ltg = new LineTag();
                    ltg.AttachedImage1 = orig;
                    ltg.AttachedImage2 = src;
                    new_line.Tag = ltg;
                    origtag.AttachedOutline.Stroke = Brushes.Black;
                    itg.AttachedOutline.Stroke = Brushes.Black;
                    new_line = null;
                }*/
            //}

            /*if (myBoard.dragMode == CBoard.MouseMode.DragImage && myBoard.selectedObject == this)
            {
                //CBImage src = this;
                MoveOutline(pos);
                MoveImage(pos);
                //Canvas.SetLeft(myOutline, pos.X + move_xo - myOutline.StrokeThickness);
                //Canvas.SetTop(myOutline, pos.Y + move_yo - myOutline.StrokeThickness);
                //Canvas.SetLeft(myImage, pos.X + move_xo);
                //Canvas.SetTop(myImage, pos.Y + move_yo);

                //MoveImage(pos);
                //MoveOutline(pos);
                RelocateLines();
                myBoard.Deselect();
                move_xo = 0;
                move_yo = 0;
                myImage.ReleaseMouseCapture();
                myBoard.dragMode = CBoard.MouseMode.None;
            }*/
        }
        
        public void Delete()
        {
            //delete image
            //delete lines
            //delete references to lines in other images
            //Image src2 = (Image)select_object;
            //ImageTag itg2 = (ImageTag)src2.Tag;
            foreach (CBLine ll in AttachedLines1)
            {
                ll.Delete(false);
                myBoard.vertices.Remove(ll);
            }
            foreach (CBLine ll in AttachedLines2)
            {
                ll.Delete(true);
                myBoard.vertices.Remove(ll);
            }
            ShowOutline(false);
            ShowImage(false);
        }
    }
}
