//Common elements

module diode(){
    //facing down along Z
    union(){
        difference(){
            cylinder($fn=12,h=5.3, d=6);
            translate([0,0,-1e-2])cylinder($fn=10,h=3, d=3);
        }
        translate([0,0,4.9])cylinder(h=2, d=5);
        translate([0,0,6.5])cylinder($fn=22, h=3.3, d=6);
        translate([-1.1,-3,7.3])cube([1.6,6,6]);
        //translate([-0.8,-3,7.3])cube([1.6,6,6]); //board is not quite centered
    }
}

module motor(){ //large motor with 2 holes in rotor, bottom surface at Z=0, rotation axis centered on Z
    difference(){
        union(){
            cylinder(h=16,d=30);
            cylinder(h=5,d=34.5);
            translate([0,0,6])cylinder(h=10,d=34.5);
            translate([0,0,-1])cylinder(h=3,d=9);
            translate([10,-3,1])cube([10,6,4]);
        }
        translate([0,0,-2])cylinder(h=20,d=6);
        nc=8;///sqrt(2);
        for(a=[0:90:270]){ //stator 4x M2.5 hole insertion depth ~3 mm
            rotate([0,0,a])translate([0,nc,-2])cylinder(h=5,d=2.5);
        }
        for(a=[0:180:270]){ //rotor 2x M2.5 hole insertion depth ~2.5 mm
            rotate([0,0,a])translate([0,nc,16-2.5])cylinder(h=5,d=2.5);
        }
    }
}

module oring(){
    $fn=16;
    rotate_extrude() translate([1.5,0,0]) circle(d=1);
}

module m2bolt(lng){
    translate([0,0,-1e-2])cylinder($fn=10,h=lng, d=2);
    translate([0,0,-1.9])
    difference(){
        cylinder($fn=10,h=1.9, d=3.98);
        translate([0,0,-1])cylinder($fn=6,h=2, d=1.77);
    }
}

module m2washer(){
    difference(){
        cylinder($fn=10,h=0.5, d=5);
        translate([0,0,-1])cylinder($fn=10,h=2, d=2);
    }
}

module m25washer(){
    difference(){
        cylinder($fn=10,h=0.5, d=6);
        translate([0,0,-1])cylinder($fn=10,h=2, d=2.5);
    }
}


module m2nut(){
    difference(){
        cylinder($fn=6,h=1.7, d=4.0/cos(30));
        translate([0,0,-1])cylinder($fn=10,h=3, d=2);
    }
}

module m25bolt(l){
    difference(){
        cylinder($fn=12,h=2.4,d=4.2);
        translate([0,0,0.9])cylinder($fn=6,h=3,d=2.6);
    }
    translate([0,0,-l+0.1])cylinder($fn=10,h=l+0.1,d=2.5);
}

module m25nut(){
    difference(){
        cylinder($fn=6,h=2.0, d=4.9/cos(30));
        translate([0,0,-1])cylinder($fn=10,h=4, d=2.5);
    }
}

module bolts_add(coords,ztop,od){
    delta=0.1;
    for(a=coords){
        translate([a[0],a[1],delta])cylinder(h=ztop-delta,d=od);
    }
}
module bolts_subtract(coords,ztop,od,depth){
    delta=0.1;
    for(a=coords){
        translate([a[0],a[1],ztop-depth])cylinder($fn=12,h=depth+delta,d=od);
    }
}
module bolts_subtract2d(coords,ztop,od,depth){
    for(a=coords){
        translate([a[0],a[1],0])circle($fn=12,d=od);
    }
}