use <ccube.scad>
use <Boards.scad>
use <common.scad>
use <Mirror holder 2.scad>
use <LD Holder 4.scad>
use <Encoder ring generator.scad>

module roundedcube2d(size,radius){
    translate([-size[0]/2,-size[1]/2,0])
    hull(){
        $fn=24;
    translate([radius,radius,0])circle(r=radius);
    translate([-radius+size[0],radius,0])circle(r=radius);
    translate([-radius+size[0],-radius+size[1],0])circle(r=radius);
    translate([radius,-radius+size[1],0])circle(r=radius);
    }
}

module roundedcube(size,radius){
    linear_extrude(height=size[2])
    roundedcube2d(size,radius);
}

box_outer=440; //side length of outside of box
box_height=50; //overall outside height of box

metal_thickness=5;//metal underneath motor
metal_side=48*2;//side length of metal under motor
metal_cutout_side=metal_side+2*2;//side length of cutout underneath motor (should be slightly larger than size of metal)
metal_underneath=1;//vertical empty space under metal, to fit bolt heads and other stuff
metal_under_adj_washers=0.5;//distance to leave between standoff tops and actual top of metal to insert adjustment washers later
motor_thickness=16;
ld_holder_height=11.5;//(>0) vertical distance from LD beam center to bottom of LD holder
mirror_holder_height=18;//(>0) vertical distance from LD beam center on mirror to bottom of mirror holder (and top of motor)
pcb_thickness=1.6;//thickness of LD and main PCBs
main_pcb_offset=18;//vertical offset of main PCB from top of metal (and bottom of motor)
main_pcb_under=23;//vertical distance to keep clear under main PCB; brushless33 click 23mm, eth jack 15mm, teensy+poe 17mm
main_pcb_cutout_od=2*(92.075+
13)/cos(360/16);//circumscribed 8-sided circle OD
beam_plane_z=box_height;//z coord of beam plane from which vertical cutout coordinates are calculated
ld_pcb_mount_cutout_od=310;//OD of cutout circle for mounting point of LD PCB (touching PCB) - needs to include space for LD wires to wrap around PCBs
ld_pcb_mount_under=2;//undercut for LD PCB mount section only
ld_pcb_under_adj_washers=0.0;//distance to leave between standoff tops and actual bottom of PCB to insert adjustment washers later
wire_run_cutout_od=360;//OD of cutout circle for ethernet cable and other wires outside LD PCB mount points
ld_pcb_wire_cutout_under=13;//vertical space between bottom of wire run cutout and bottom of LD PCB above it
ld_pcb_outer_cutout_od=214*2;//outermost circle cutout
ld_pcb_outer_under=6;//vertical space under LD mounting locations
delta=0.05;//ensure shape intersections

metaltopz=beam_plane_z-mirror_holder_height-motor_thickness;

mbcsl=40;//radius of triangle bolts for metal
metal_bolt_coords=[for(a=[0:120:359]) mbcsl*[sin(a),cos(a)] ];//[x,y] coords for bolt and insert hole locations, centered on rotation axis
mrbcsl=8;//radius of square bolts for motor
motor_bolt_coords=[for(a=[0:90:359]) mrbcsl*[sin(a),cos(a)] ];//[x,y] coords for bolt and insert hole locations, centered on rotation axis
motor_wire_hole_coords=[[-24,0]];//hole for motor wires to pass to under metal
opto_d=77.5/2+1.78;//distance from origin of optoisolator mounting bolt hole line tangent
opto_mount_hole_coords=[[-7,-opto_d],[+7,-opto_d]];//[X,Y] coords for M2.5 bolts for mounting optoisolator
enc_ring_offset=6.8;//Z offset from top of metal to optical center of optical encoder

mpbr=95;//radius of bolts and inserts for main PCB
main_pcb_bolt_coords=[for(a=[45/2:45:359]) mpbr*[sin(a),cos(a)] ];
lpbxy=[51.435,134.303,54.61,139.065];//XY coords of LD PCB side mount hole (2.5mm) in PCB basis and LD PCB alignment hole (1mm)
lpbr=[sqrt(lpbxy[0]*lpbxy[0]+lpbxy[1]*lpbxy[1]),150.18,sqrt(lpbxy[2]*lpbxy[2]+lpbxy[3]*lpbxy[3])];//radius of bolts and inserts for LD PCBs
ld_pcb_bolt_coords=concat([for(a=[-atan2(lpbxy[0],lpbxy[1]):45:359]) lpbr[0]*[sin(a),cos(a)]],[for(a=[atan2(lpbxy[0],lpbxy[1]):45:359]) lpbr[0]*[sin(a),cos(a)]],[for(a=[0:45:359]) lpbr[1]*[sin(a),cos(a)]]);
ld_pcb_alignment_coords=concat([for(a=[-atan2(lpbxy[2],lpbxy[3]):45:359]) lpbr[2]*[sin(a),cos(a)]],[for(a=[atan2(lpbxy[2],lpbxy[3]):45:359]) lpbr[2]*[sin(a),cos(a)]]);
bolt_spacer_od=8;
bolt_insert_od=4;//for M2.5 and M3 bolt
bolt_insert_depth=7;//for M2.5 bolts 4mm 6mm
lid_bolt_insert_depth=15;//for 16mm long M3 bolt

rounding_div=3.5;//rounded corner divider

lid_bolt_coords=[[-1,-1],[-1,1],[1,-1],[1,1]]*box_outer*0.385;

module eth_jack_cut(){
    translate([0,-delta,0])ccube([17.5,20+2*delta,23],[0.5,0,0.5]);//large cube
    translate([0,20,-1])ccube([17,115,19],[0.5,0.5,0.5]);//small extending back cube
    translate([0,delta,0])ccube([19.4,8,36.6],[0.5,1,0.5]);//front thin cube 2.4mm insert depth
    translate([0,0,28.96/2])rotate([-90,0,0])cylinder(h=bolt_insert_depth, d=bolt_insert_od);
    translate([0,0,-28.96/2])rotate([-90,0,0])cylinder(h=bolt_insert_depth, d=bolt_insert_od);
}

module cables_cutout(){
    //ethernet cable to main PCB
    translate([22,40,metaltopz+main_pcb_offset-13])rotate([0,0,0])ccube([16,95,30],[0.5,0,0]);
    translate([25,125,metaltopz+main_pcb_offset-10])rotate([0,0,30])ccube([8,60,30],[0.5,0,0]);
    //USB cable to main PCB
    translate([58,0,metaltopz+main_pcb_offset-18.5])ccube([16,120,30],[0.5,0,0]);
    //Motor power wires to boost converter
    //translate([-29,-58,metaltopz+main_pcb_offset])ccube([5,127,10],[0.5,1,0.5]);
    //Motor power wires from boost converter
    //translate([-68,-58,metaltopz+main_pcb_offset])ccube([5,127,10],[0.5,1,0.5]);
}

module lid(){
    lid_height=15;
    lid_thickness=3;
    difference(){
        roundedcube([box_outer,box_outer,lid_height],box_outer/rounding_div);
        translate([0,0,-delta])cylinder($fn=48,d=ld_pcb_outer_cutout_od,h=lid_height-lid_thickness+delta);
        translate([0,0,lid_thickness])difference(){
            cylinder(d=2*box_outer,h=box_height);
            translate([0,0,-delta])cylinder($fn=48,d=ld_pcb_outer_cutout_od+2*lid_thickness,h=box_height+2*delta);
        }
        bolts_subtract(lid_bolt_coords, lid_thickness,3, lid_thickness+2*delta);
    }
}

module ballast_cut(){
    //length,width,radius,depth,number
    l=35;
    w=20;
    r=200;
    d=8*3;
    n=24;
    for(i=[1:n]){
        rotate([0,0,360*i/n])translate([r,0,delta])ccube([w,l,d+delta],[0.5,0.5,1]);
    }
}

module box1(){
    difference(){
        roundedcube([box_outer,box_outer,box_height],box_outer/rounding_div);
        translate([0,0,metaltopz-metal_thickness-metal_underneath])roundedcube([metal_cutout_side,metal_cutout_side,box_height],metal_cutout_side/rounding_div);
        translate([0,0,metaltopz+main_pcb_offset-main_pcb_under])rotate([0,0,45/2])cylinder($fn=8,d=main_pcb_cutout_od,h=box_height);
        translate([0,0,beam_plane_z-ld_holder_height-pcb_thickness-ld_pcb_mount_under])cylinder(d=ld_pcb_mount_cutout_od,h=box_height);
        translate([0,0,beam_plane_z-ld_holder_height-pcb_thickness-ld_pcb_outer_under])difference(){
            cylinder($fn=48,d=ld_pcb_outer_cutout_od,h=box_height);
            translate([0,0,-delta])cylinder(d=ld_pcb_mount_cutout_od-delta,h=box_height+2*delta);
        }
        translate([0,0,beam_plane_z-ld_holder_height-pcb_thickness-ld_pcb_wire_cutout_under])difference(){
            cylinder(d=wire_run_cutout_od,h=box_height);
            translate([0,0,-delta])cylinder(d=ld_pcb_mount_cutout_od-delta,h=box_height+2*delta);
        }
        translate([0,0,beam_plane_z-ld_holder_height-pcb_thickness-ld_pcb_outer_under])ballast_cut();
    }
}

module box2(){
    difference(){
        union(){
            box1();
            bolts_add(metal_bolt_coords, metaltopz-metal_thickness-metal_under_adj_washers,bolt_spacer_od);
            bolts_add(main_pcb_bolt_coords, metaltopz+main_pcb_offset,bolt_spacer_od);
            bolts_add(ld_pcb_bolt_coords, beam_plane_z-ld_holder_height-pcb_thickness-ld_pcb_under_adj_washers,bolt_spacer_od);
            bolts_add(ld_pcb_alignment_coords, beam_plane_z-ld_holder_height-pcb_thickness-ld_pcb_under_adj_washers,bolt_spacer_od);
        }
        bolts_subtract(metal_bolt_coords, metaltopz-metal_thickness-metal_under_adj_washers,bolt_insert_od, bolt_insert_depth);
        bolts_subtract(motor_bolt_coords, metaltopz-metal_thickness, 7, 4); //bolt heads and washer under motor
        bolts_subtract(motor_wire_hole_coords, metaltopz-metal_thickness, 6.2, 3.4); //wires under metal
        translate([motor_wire_hole_coords[0][0],motor_wire_hole_coords[0][1],metaltopz-metal_thickness+delta])ccube([35,4,3+delta],[1,0.5,1]); //slot for wires under metal
        bolts_subtract(opto_mount_hole_coords, metaltopz-metal_thickness, 7, 4); //nut and bolt end under optoisolator
        bolts_subtract(main_pcb_bolt_coords, metaltopz+main_pcb_offset,bolt_insert_od, bolt_insert_depth);
        bolts_subtract(ld_pcb_bolt_coords, beam_plane_z-ld_holder_height-pcb_thickness-ld_pcb_under_adj_washers,bolt_insert_od, bolt_insert_depth);
        bolts_subtract(ld_pcb_alignment_coords, beam_plane_z-ld_holder_height-pcb_thickness-ld_pcb_under_adj_washers,1, 2);
        bolts_subtract(lid_bolt_coords, box_height,bolt_insert_od, lid_bolt_insert_depth);//lid attachment on top
        bolts_subtract(lid_bolt_coords, lid_bolt_insert_depth-delta,bolt_insert_od, lid_bolt_insert_depth);//lid attachment on bottom
        rotate([0,0,-90])translate([-box_outer/3+5,-box_outer/2+11+2.3-delta,box_height/2+6.9])rotate([0,0,-24])eth_jack_cut();
        cables_cutout();
        //translate([0,0,-delta])cylinder(h=20,d=10);//for visual confirmation of depth
    }
}


module metalpiece(){
    difference(){
    roundedcube([metal_side,metal_side,metal_thickness],metal_side/rounding_div);//main metal piece
        translate([0,0,-delta])cylinder(h=metal_thickness+2*delta,d=11);
    bolts_subtract(motor_bolt_coords, metal_thickness, 2.6, metal_thickness+delta);
    bolts_subtract(metal_bolt_coords, metal_thickness, 2.6, metal_thickness+delta);
        bolts_subtract(opto_mount_hole_coords, metal_thickness, 2.6, metal_thickness+delta);
        bolts_subtract(motor_wire_hole_coords, metal_thickness, 6, metal_thickness+delta); //wires to pass under metal
    }
}

module metalpiece2d(){
    difference(){
    roundedcube2d([metal_side,metal_side,metal_thickness],metal_side/rounding_div);//main metal piece
        circle(d=11);
    bolts_subtract2d(motor_bolt_coords, metal_thickness, 2.6, metal_thickness+delta);
    bolts_subtract2d(metal_bolt_coords, metal_thickness, 2.6, metal_thickness+delta);
        bolts_subtract2d(opto_mount_hole_coords, metal_thickness, 2.6, metal_thickness+delta);
        bolts_subtract2d(motor_wire_hole_coords, metal_thickness, 6, metal_thickness+delta); //wires to pass under metal
    }
}

module accessories(){
    //translate([0,0,metaltopz-metal_thickness])metalpiece();
    //rotate([0,0,-90])translate([opto_d,0,metaltopz+delta])optoisolatorasm();
    //rotate([0,0,-0])translate([0,0,metaltopz+6.8])ring3d();
    translate([0,0,metaltopz+delta])rotate([0,0,180])motor();
    //translate([0,0,beam_plane_z])laserbeam(170,0);
    //translate([0,0,metaltopz+main_pcb_offset+delta])mainboard();
    translate([0,0,beam_plane_z-ld_holder_height-pcb_thickness+delta])rotate([0,0,0])ldboard();
    rotate([0,0,0])translate([185,0,beam_plane_z-ld_holder_height+delta])ldholderasm();
    rotate([0,0,0]){
        translate([0,0,metaltopz+motor_thickness+2*delta])mirholderasm();
        translate([0,0,metaltopz+enc_ring_offset])ring3d();
        translate([27,0,metaltopz+enc_ring_offset+2])m25bolt(4);
    }
}

box2();
//translate([0,0,box_height+15])lid();
//accessories();
//metalpiece2d();
//metalpiece();
