//PCBs

module ldboard(){
    bth=1.6;//pcb thickness
    rad=209;//radius of outside of board from center of rotation
    bin=131.445;//distance from center of rotation to inner flat (radius of inscribed circle)
    bolt_coords=[[-51.435,134.303],[51.435,134.303],[0,150.78]];
    alignment_coords=[[-54.61,139.065],[54.61,139.065]];
    mhr1=158;//M2 mounting hole radius 1
    mhr2=185;//M2 mounting hole radius 2
    mha1=166.6;//1mm dowel pin radius 1
    mha2=193.6;//1mm dowel pin radius 2
    difference(){
        intersection(){
            cylinder(r=rad,h=bth);
            rotate([0,0,-360/16])translate([0,0,-1])cube([rad+1,rad+1,bth+2]);
            rotate([0,0,-90+360/16])translate([0,0,-1])cube([rad+1,rad+1,bth+2]);
            translate([bin,-rad/2,-1])cube([rad,rad,bth+2]);
        }
        for(a=bolt_coords){
            rotate([0,0,-90])translate([a[0],a[1],-1])cylinder(h=bth+2,d=2.8);
        }
        for(a=alignment_coords){
            rotate([0,0,-90])translate([a[0],a[1],-1])cylinder(h=bth+2,d=1);
        }
        for(a=[0:15]){
            rotate([0,0,22.5-45/64-a*45/16])translate([mhr1,0,-1])cylinder(h=bth+2,d=2);
            rotate([0,0,22.5-45/64-a*45/16])translate([mha1,0,-1])cylinder(h=bth+2,d=1);
        }
        for(a=[0:15]){
            rotate([0,0,22.5-45/64-45/32-a*45/16])translate([mhr2,0,-1])cylinder(h=bth+2,d=2);
            rotate([0,0,22.5-45/64-45/32-a*45/16])translate([mha2,0,-1])cylinder(h=bth+2,d=1);
        }
    }
}

module mainboard(){
    bth=1.6;//pcb thickness
    mrad=25;//motor cutout radius
    bir=92.075;//board distance from center to flat (radius of inscribed circle)
    mhr=95;//mounting hole radius
    rotate([0,0,360/16])difference(){
        cylinder($fn=8,h=bth,r=bir/cos(360/16));
        translate([0,0,-1])cylinder(h=bth+2,r=mrad);
        for(a=[0:7]){
            rotate([0,0,-a*45])translate([mhr,0,-1])cylinder(h=bth+2,d=2);
        }
    }
}

ldboard();
//rotate([0,0,360/8])translate([0,0,1])ldboard();
mainboard();