void setupEthernet(){
  /*
  uint8_t mac[6];
  Ethernet.macAddress(mac);  // This is informative; it retrieves, not sets
  printf("MAC = %02x:%02x:%02x:%02x:%02x:%02x\r\n",mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);

  // Add listeners
  // It's important to add these before doing anything with Ethernet
  // so no events are missed.
  
  // Listen for link changes
  Ethernet.onLinkState([](bool state) {
    printf("[Ethernet] Link %s\r\n", state ? "ON" : "OFF");
  });

  // Listen for address changes
  Ethernet.onAddressChanged([]() {
    IPAddress ip = Ethernet.localIP();
    bool hasIP = (ip != INADDR_NONE);
    if (hasIP) {
      printf("[Ethernet] Address changed:\r\n");

      printf("    Local IP = %u.%u.%u.%u\r\n", ip[0], ip[1], ip[2], ip[3]);
      ip = Ethernet.subnetMask();
      printf("    Subnet   = %u.%u.%u.%u\r\n", ip[0], ip[1], ip[2], ip[3]);
      ip = Ethernet.gatewayIP();
      printf("    Gateway  = %u.%u.%u.%u\r\n", ip[0], ip[1], ip[2], ip[3]);
      ip = Ethernet.dnsServerIP();
      if (ip != INADDR_NONE) {  // May happen with static IP
        printf("    DNS      = %u.%u.%u.%u\r\n", ip[0], ip[1], ip[2], ip[3]);
      }
    } else {
      printf("[Ethernet] Address changed: No IP address\r\n");
    }
  });*/

  if (initEthernet()) {
    // Start the server
    //printf("Starting server on port %u...", kServerPort);
    server.begin(kServerPort);
    //printf("%s\r\n", (server) ? "Done." : "FAILED!");
  }
}

bool initEthernet() {
  // DHCP
  if (staticIP == INADDR_NONE) {
    //printf("Starting Ethernet with DHCP...\r\n");
    if (!Ethernet.begin()) {
      //printf("Failed to start Ethernet\r\n");
      return false;
    }

    // We can choose not to wait and rely on the listener to tell us
    // when an address has been assigned
    if (kDHCPTimeout > 0) {
      //printf("Waiting for IP address...\r\n");
      if (!Ethernet.waitForLocalIP(kDHCPTimeout)) {
        //printf("No IP address yet\r\n");
        // We may still get an address later, after the timeout,
        // so continue instead of returning
      }
    }
  } else {
    // Static IP
    //printf("Starting Ethernet with static IP...\r\n");
    if (!Ethernet.begin(staticIP, subnetMask, gateway)) {
      //printf("Failed to start Ethernet\r\n");
      return false;
    }

    // When setting a static IP, the address is changed immediately,
    // but the link may not be up; optionally wait for the link here
    if (kLinkTimeout > 0) {
      //printf("Waiting for link...\r\n");
      if (!Ethernet.waitForLink(kLinkTimeout)) {
        //printf("No link yet\r\n");
        // We may still see a link later, after the timeout, so
        // continue instead of returning
      }
    }
  }

  return true;
}

void ethernetLEDState(bool on){
  enet_enable_led(on); //the following code has been moved into this function in C:\Users\Max\Documents\Arduino\libraries\QNEthernet\src\lwip_t41.c
  /*if(!enet_has_hardware()){ return; }//wait until communication is initialized
  if(on){
    mdio_write(PHY_LEDCR, PHY_LEDCR_VALUE); //default state from qnethernet/drivers/driver_teensy41.c , line 584
  }else{
    mdio_write(PHY_LEDCR, (PHY_LEDCR_VALUE&(~0x02))|0x10); //LED always off (see DP83825I datasheet LEDCR_Register)
  }*/
}

uint32_t readUInt(ClientState &state){
  uint32_t c=0;
  for(int ca=0; ca<4; ca++){
    c=(c<<8)|((byte)state.client.read());
  }
  return c;
}

void writeUInt(ClientState &state, uint32_t d, bool immediate){
  state.client.write((byte)((d>>24)&0xFF));
  state.client.write((byte)((d>>16)&0xFF));
  state.client.write((byte)((d>>8)&0xFF));
  state.client.write((byte)((d>>0)&0xFF));
  if(immediate){
    state.client.flush();//output above bytes
  }
}

// The simplest possible (very non-compliant) HTTP server. Respond to
// any input with an HTTP/1.1 response.
void processClientData(ClientState &state) {
  // Loop over available data until an empty line or no more data
  // Note that if emptyLine starts as false then this will ignore any
  // initial blank line.
  int line=0;
  const int outbuflen=1200;
  static char outstr[outbuflen];
  outstr[0]=0; //null terminate string if not written below
  if(state.parsingState == 0){ //need to read first HTTP line
    if(state.client.available()>0){
      state.lastRead = millis();
    }
    while (true) { //read header to first line, storing the beginning of it into instr buffer
      int avail = state.client.available();
      if (avail <= 0) {
        return;
      }
      int c = state.client.read();
      //printf("%c", c);
      if(line == 0 && state.inctr<(cinbuflen-1)){
        state.instr[state.inctr]=c;
        state.inctr++;
      }
      if (c == '\n' || state.inctr>=(cinbuflen-1)) {
        state.instr[state.inctr]=0; //string end terminator
        line++;
        state.parsingState=1;//have first line, need to read to end of header with an empty line
        state.emptyLine=(c=='\n');
        break;
      }
    }
    state.instr[state.inctr]=0; //string end terminator
  
    if(state.inctr>5){// "GET /xyz HTTP/1.1\r\n" or "ASTROx\r\n"
      if(state.instr[0]=='G' && state.instr[1]=='E' && state.instr[2]=='T' && state.instr[3]==' ' && state.instr[4]=='/'){ // GET request in HTTP
        //Text data for changing settings or requesting information
        switch(state.instr[5]){
          case 'x': //"GET /x?a=w HTTP/1.1" a=w/r/d to write/read/discard EEPROM values
            //x# access EEPROM values
            if(state.inctr>10 && state.instr[6]=='?'){
              switch(state.instr[9]){
                case 'w': //write values to EEPROM
                  writeToEeprom();
                  sprintf(outstr,"Values written to EEPROM");
                  break;
                case 'r': //read values from EEPROM
                  loadFromEeprom();
                  sprintf(outstr,"Values restored from EEPROM");
                  break;
                case 'd': //clear values from EEPROM and go back to program defaults
                  discardEeprom();
                  sprintf(outstr,"Values returned to program defaults");
                  break;
              }
            }
            break;
          case 'p': //"GET /p?ps=0 HTTP/1.1" : ps, vs, ns, ta, oa, ms
            //ps set pixel phase shift
            if(state.inctr>10 && state.instr[6]=='?'){
              float pst=0;
              switch(state.instr[10]){
                case '1': pst=-10; break;
                case '2': pst=-1; break;
                case '3': pst=-0.1; break;
                case '4': pst=-0.01; break;
                case '6': pst=0.01; break;
                case '7': pst=0.1; break;
                case '8': pst=1; break;
                case '9': pst=10; break;
              }
              float nv;
              byte mds;
              switch(state.instr[7]){
                case 'p': nv=theta_pixel_shift+pst; if(nv<-256) nv+=512; if(nv>256) nv-=512; theta_pixel_shift=nv; break;
                case 'v': nv=theta_pixel_vshift+pst; if(nv<-751) nv=-751; if(nv>751) nv=751; theta_pixel_vshift=nv; break;
                case 'n': north_pixel_shift+=pst; if(display_active) generateLaserBuffer();  break;
                case 't': nv=theta_alpha+(pst/10); if(nv<0) nv=0; if(nv>0.9999f) nv=0.9999f; theta_alpha=nv; break;
                case 'o': nv=omega_alpha+(pst/10); if(nv<0) nv=0; if(nv>0.9999f) nv=0.9999f; omega_alpha=nv; break;
                case 'm': nv=motor_default_speed+(pst*10); if(nv<0) nv=0; if(nv>motor_max_speed) nv=motor_max_speed; motor_default_speed=nv; if(display_active) setMotorLevel(true, motor_default_speed); break;
              }
              sprintf(outstr,"Value updated to %.3f<br/>\r\n",nv);
            }
            break;
          case 'b': //"GET /b?bl=0 HTTP/1.1"
            //change brightness level
            if(state.inctr>10 && state.instr[6]=='?'){
              if(state.instr[10]>='0' && state.instr[10]<='2'){
                byte dm=state.instr[10]-'0';
                setBrightMode(dm);
                sprintf(outstr,"Bright mode set to %i<br/>\r\n", dm);
              }
            }
            break;
          case 'd':
            //d describe data format
            sprintf(outstr,("After establishing a TCP/IP connection, send 'ASTROy\\r\\n', after which projector returns a 4 byte confirmation and keeps the connection open. Send a 4 byte uint command followed by data. 16384=full 16384 byte screen buffer to follow (2 bits per pixel), (16383 to 0)=this many bytes to follow for dot mode (18 bits per pixel, 9 MSBs theta, 7 next MSBs phi, 2 LSBs brightness). Projector will return number of received bytes as 4 byte uint. Cmds 65536 and higher will return a 4 byte response. Use 'ASTROf\\r\\n' for firmware upload, followed by 4 byte uint of number of bytes to follow, then full contents of .hex file, wait for 4 byte response, send 4 byte code to write flash memory. On error a text message is returned and connection is closed.\r\n"));
            break;
          case 's':
            //s start display
            startDisplay(true);
            sprintf(outstr,("Display started<br/>\r\n"));
            break;
          case 'e':
            //e stop display
            stopDisplay();
            sprintf(outstr,("Display stopped<br/>\r\n"));
        }
        state.parsingState=1;//get rest of header and send HTTP response
      }
      if(state.instr[0]=='A' && state.instr[1]=='S' && state.instr[2]=='T' && state.instr[3]=='R' && state.instr[4]=='O'){ // ASTRO binary request
        //binary data for pixel display or hex file data for firmware update
        switch(state.instr[5]){ //"ASTROx\r\n"
          case 'f'://firmware upload
            state.parsingState=16;
            stopDisplay();//make sure nothing is operational
            state.keepopen=true;
            break;
          case 'y'://binary display data (automatically determine format)
            if(display_auto_start) { startDisplay(true); }
            state.parsingState=17;//receive more binary data without closing connection
            state.keepopen=true;
            burst_timer=0;
            break;
        }
        if(state.parsingState!=1){//confirm connection
          uint32_t ccd=0x58AD4166;//binary connection response code
          writeUInt(state, ccd, true);
        }
      }
    }
  }
  if(state.parsingState==1){//need to read rest of header to empty line
    //ignore all header lines
    while (true) { //read header to first empty line
      int avail = state.client.available();
      if (avail <= 0) {
        return;
      }
      state.lastRead = millis();
      int c = state.client.read();
      if (c == '\n') {
        if(state.emptyLine){ //empty line has been read
          state.parsingState=11;//move on to read data (or not)
          state.inctr=0;//reset input counter
          break;
        }else{
          state.emptyLine=true;
        }
      }else{
        if(c!='\r' && state.emptyLine){
          state.emptyLine=false;
        }
      }
    }
  }

  if(state.parsingState==16){ //reading lines for firmware update
    if (state.client.available() < 4) { //read 4-byte length of bytes to receive
      return;
    }
    state.lastRead = millis();
    uint32_t c=readUInt(state);//get number of bytes
    if(c>0 && c<=1000000){
      state.bytesToReceive=c;
      state.inctr=0;
      state.prevAddr=0;
      state.parsingState=106;//receive hex data lines
    }else{
      state.parsingState=200;//error with binary request
      sprintf(outstr,("error: number of bytes to receive is too large"));
    }
  }
  if(state.parsingState==17){ //reading binary data for display
    if (state.client.available() < 4) { //read 4-byte length of bytes to receive
      return;
    }
    ethBytesReceived+=4;
    ethProcessTime=0;
    //Serial.println("Reading binary data for display");
    state.lastRead = millis();
    uint32_t c=readUInt(state);//get number of bytes
    if(c>16384){//binary command
      if(burst_timer<cmd_burst_interval){//avoid taking random action if somehow desynchronized with byte stream
        state.parsingState=200;
        sprintf(outstr,("Command burst limit exceeded"));
      }
      burst_timer=0;
      //take some action
      uint32_t ret=c;
      switch(c){
        case 65536://stop display
          stopDisplay(); break;
        case 65537://start display
          startDisplay(true); break;
        case 65540://set dark mode
          setBrightMode(0); break;
        case 65541://set bright mode 1
          setBrightMode(1); break;
        case 65542://set bright mode 2
          setBrightMode(2); break;
        case 65550://set dot overwrite mode
          ds_or_mode=false; break;
        case 65551://set dot "or" mode
          ds_or_mode=true; break;
        case 65560://set low motor speed
          if(display_active) setMotorLevel(true, 0); break;
        case 65561://set med motor speed
          if(display_active) setMotorLevel(true, 64); break;
        case 65562://set high motor speed
          if(display_active) setMotorLevel(true, 96); break;
        case 65563://set max motor speed
          if(display_active) setMotorLevel(true, 128); break;
        case 65564://set max motor speed
          if(display_active) setMotorLevel(true, 160); break;
        case 65565://set max motor speed
          if(display_active) setMotorLevel(true, 192); break;
        case 131072://request current IP address
          ret=(uint32_t)staticIP;
          break;
        case 131073://request current server port
          ret=kServerPort;
          break;
        case 131100://request voltage [mV]
          ret=ina_bus_voltage(INA232_addr)*1000;
          break;
        case 131101://request current [mA]
          ret=ina_shunt_voltage(INA232_addr)*(1000 / 0.03f);
          break;
        case 131110://request operational state
          ret=opt_state;
          break;
        case 131111://request motor speed [mHz]
          ret=get_motor_speed()*1000;
          break;
        default://not a valid command
          state.parsingState=200;
          sprintf(outstr,("not a valid command"));
          break;
      }
      if(state.parsingState==17){//successfully completed
        writeUInt(state, ret, true);//return data to client
        return;//come back to this state again to receive more binary data
      }
    }
    if(c==16384){//receive full screen bitmap data
      state.bytesToReceive=16384;
      state.bytesReceived=0;
      state.upperAddr=0;
      state.parsingState=28;//receive binary data
    }
    if(c>=0 && c<16384){
      state.bytesToReceive=c;
      state.bytesReceived=0;
      clearPixelBuffer();
      if(c==0){
        state.parsingState=17;//clear display with zero dots
      }else{
        state.inctr=0;
        state.parsingState=27;//receive known number of dots
      }
    }
  }
  if(state.parsingState==27){ //get dots
    if (state.client.available() <= 0) {
      return;
    }
    bool orm=ds_or_mode;//get local copy
    state.lastRead = millis();
    while(state.client.available()>0){
      state.instr[state.inctr]=state.client.read();
      state.inctr++;
      state.bytesReceived++;
      if(state.inctr>=9||state.bytesReceived>=state.bytesToReceive){//groups of 4 18-bit dots = 72 bits = 9 bytes
        uint32_t dtd=0, dts=0;
        int bi=0;
        for(int bc=0; bc<state.inctr; bc++){
          dtd=(dtd<<8)|state.instr[bc];
          bi+=8;
          if(bi>=18){
            dts=dtd>>(bi-18);
            if(orm){
              setPixelOr((dts>>2)&0x7F,dts>>9,dts&0x03);
            }else{
              setPixel((dts>>2)&0x7F,dts>>9,dts&0x03);
            }
            bi-=18;
          }
        }
        state.inctr=0;
      }
      if(state.bytesReceived>=state.bytesToReceive){
        uint32_t pt=ethProcessTime;
        if(pt>ethDataMaxTime){ethDataMaxTime=pt;}
        ethProcessTime=0;
        generateLaserBuffer();
        pt=ethProcessTime;
        if(pt>pixGenMaxTime){pixGenMaxTime=pt;}
        writeUInt(state, state.bytesReceived, true);//return number of bytes received as indicator of success
        state.parsingState=17;//receive more binary data without closing connection
        ethBytesReceived+=state.bytesReceived;
      }
    }
  }
  if(state.parsingState==28){ //reading binary data for bitmap
    if (state.client.available() <= 0) {
      return;
    }
    state.lastRead = millis();
    uint32_t dti=state.upperAddr;
    while(state.client.available()>0){
      uint32_t si=state.client.read();
      state.bytesReceived++;
      si<<=24;
      for(int q=0; q<4; q++){
        dti>>=2;
        dti|=(si&0xC0000000);//lower columns end up as LSBs
        si<<=2;
      }
      if(state.bytesReceived%4==0){
        pixel_buffer[state.bytesReceived/4-1]=dti;
        //dti=0;
      }
      if(state.bytesReceived>=16384){
        uint32_t pt=ethProcessTime;
        if(pt>ethDataMaxTime){ethDataMaxTime=pt;}
        ethProcessTime=0;
        generateLaserBuffer();
        pt=ethProcessTime;
        if(pt>pixGenMaxTime){pixGenMaxTime=pt;}
        writeUInt(state, state.bytesReceived, true);//return number of bytes received as indicator of success
        state.parsingState=17;//receive more binary data without closing connection
        ethBytesReceived+=state.bytesReceived;        
      }
    }
  }

  if(state.parsingState==106){//receive hex lines
    if (state.client.available() <= 0) {
      return;
    }
    state.lastRead = millis();
    while(state.client.available()>0){
      char ca=state.client.read();
      state.instr[state.inctr]=ca;
      state.bytesReceived++;
      state.inctr++;
      if(ca=='\n'){//complete line received
        if(state.inctr>12 && state.instr[0]==':'){
          byte ln=hex2byte(state.instr, 1);
          byte ad1=hex2byte(state.instr, 3);
          byte ad2=hex2byte(state.instr, 5);
          byte tp=hex2byte(state.instr, 7);
          byte cs=ln+ad1+ad2+tp;
          if(state.inctr!=(13+2*ln)){
            state.parsingState=200;
            sprintf(outstr,"%s","error with hex file - line length not correct");
            break;
          }
          switch(tp){
            case 0: //hex data
              if(ln>0){
                uint32_t addr=ad1;
                addr<<=8;
                addr|=ad2;
                addr|=state.upperAddr;
                if(state.prevAddr==0){
                  if(addr!=flash_offset){
                    state.parsingState=200;
                    sprintf(outstr,"%s","error with hex file - incorrect starting address");
                  }
                }else{
                  if(addr!=(state.prevAddr+1)){
                    state.parsingState=200;
                    sprintf(outstr,"%s","error with hex file - not continuous image");
                  }
                }
                for(int wl=0; wl<ln; wl++){
                  uint32_t buf_addr=addr+wl-flash_offset;//where to write in buffer
                  if(buf_addr>=firmware_buffer_length){
                    state.parsingState=200;
                    sprintf(outstr,"%s","error with hex file - longer than available buffer");
                    break;
                  }
                  byte bb=hex2byte(state.instr, 9+2*wl);
                  firmware_buffer[buf_addr]=bb;
                  cs+=bb;
                }
                state.prevAddr=addr+ln-1;//last address received/written
                cs+=hex2byte(state.instr, 9+ln*2);
                if(cs!=0){
                  state.parsingState=200;
                  sprintf(outstr,"error with hex file - incorrect checksum 0");
                }
              }else{
                state.parsingState=200;
                sprintf(outstr,"error with hex file - incorrect format for data line 0");
              }
              break;
            case 1: //end of data
              if(ln==0){// && state.bytesReceived==state.bytesToReceive){
                cs=cs+hex2byte(state.instr, 9);
                if(cs!=0){
                  state.parsingState=200;//
                  sprintf(outstr,"%s","error with hex file - incorrect checksum1");
                }else{
                  writeUInt(state, state.bytesReceived, true);//return number of bytes received as indicator of success
                  state.parsingState=116;//success loading hex file
                }
              }else{
                state.parsingState=200;//
                sprintf(outstr,"%s","error with hex file - incorrect placement of end line1");
              }
              break;
            case 5: //starting point marker
              if(ln==4){
                uint32_t startaddr=hex2byte(state.instr, 9);
                startaddr<<=8;
                startaddr|=hex2byte(state.instr, 11);
                startaddr<<=8;
                startaddr|=hex2byte(state.instr, 13);
                startaddr<<=8;
                startaddr|=hex2byte(state.instr, 15);
                cs+=startaddr;
                cs+=startaddr>>8;
                cs+=startaddr>>16;
                cs+=startaddr>>24;
                cs=cs+hex2byte(state.instr, 17);
                if(cs!=0){
                  state.parsingState=200;//
                  sprintf(outstr,"%s","error with hex file - incorrect checksum5");
                }
                if(startaddr!=(flash_offset+0x1000)){
                  state.parsingState=200;//
                  sprintf(outstr,"%s","error with hex file - incorrect starting address5");
                }
              }else{
                state.parsingState=200;//
                sprintf(outstr,"%s","error with hex file - incorrect format for address line5");
              }
              break;
            case 4: //address upper bytes
              if(ln==2){
                byte ub1=hex2byte(state.instr, 9);
                byte ub2=hex2byte(state.instr, 11);
                state.upperAddr=ub1;
                state.upperAddr<<=8;
                state.upperAddr|=ub2;
                state.upperAddr<<=16;
                cs=cs+ub1+ub2+hex2byte(state.instr, 13);
                if(cs!=0){
                  state.parsingState=200;//
                  sprintf(outstr,"%s","error with hex file - incorrect checksum4");
                }
              }else{
                state.parsingState=200;//
                sprintf(outstr,"%s","error with hex file - incorrect format for address line4");
              }
              break;
            default: //unknown line
              state.parsingState=200;//
              sprintf(outstr,"%s","error with hex file - unknown line type");
              break;
          }
          if(state.parsingState!=106){
            break;//exit while loop
          }
        }else{
          state.parsingState=200;//
          sprintf(outstr,"%s","error with hex file - line not long enough or line not starting with colon");
          break;
        }
        state.inctr=0;
      }
      if(state.inctr>=cinbuflen){
        state.parsingState=200;//
        sprintf(outstr,"%s","error with hex file - line is too long");
        break;
      }
      //if(state.bytesReceived>=state.bytesToReceive){
        //state.parsingState=200;//error with hex file - too many bytes
        //break;
      //}
    }
  }

  if(state.parsingState==116){//successfully loaded hex file into buffer, 
    if (state.client.available() < 4) { //read 4-byte confirmation code
      return;
    }
    state.lastRead = millis();
    uint32_t c=readUInt(state);//get flash code
    if(c==0x1AE022D8){//code to start writing data to flash
      state.client.writeFully("Successfully received flash contents, Writing flash data");
      state.client.flush();
      state.client.closeOutput();
      state.keepopen=false;
      state.closedTime = millis();
      state.outputClosed = true;
      state.parsingState=255;//no further action
      updateFlashFirmware(state.prevAddr-flash_offset+1);
    }else{
      state.parsingState=200;//
      sprintf(outstr,"%s","error - no successful acivation code received");
    }
  }

  if(state.parsingState==200){//binary data error
    //IPAddress ip = state.client.remoteIP();
    //printf("Sending to client: %u.%u.%u.%u\r\n", ip[0], ip[1], ip[2], ip[3]);
    state.client.writeFully("ERROR: ");
    state.client.write(outstr);
    state.client.flush();
    state.client.closeOutput();
    state.keepopen=false;
    state.closedTime = millis();
    state.outputClosed = true;
    state.parsingState=255;//no further action
  }
  if(state.parsingState==11){//respond to received GET request with full webpage
    state.client.write("HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\n");
    state.client.write("<html><head><title>AstroDisplay 20251103</title></head><body>");
    if(display_active){
      display_active_time=display_timer;
      state.client.write("Display Active<br/>\r\n");
      state.client.write(outstr);
      state.client.write("<a href='/e'>Stop display</a><br/>\r\n");
    }else{
      state.client.write(("Display Inactive\r\n<br/>"));
      state.client.write(outstr);
      //state.client.write(("<form action='/f' method='GET'><input type='text' name='fn'/><input type='submit' value='Set filename'/></form><br/>\r\n"));
      state.client.write(("<a href='/s'>Start display</a><br/>\r\n"));
      state.client.write(("<a href='/d'>Get a description of the binary data format</a><br/>\r\n"));
      state.client.write(("<a href='/x?a=w'>Write values to EEPROM</a> | <a href='/x?a=r'>Load values from EEPROM</a> | <a href='/x?a=d'>Discard EEPROM to load defaults on reboot</a><br/>\r\n"));
      sprintf(outstr,"Timer0 LSB: %u<br/>\r\n",pxt0lsb);
      state.client.write(outstr);
      sprintf(outstr,"Timer1 delay: %u<br/>\r\n",pxt1dly);
      state.client.write(outstr);
      sprintf(outstr,"Timer2 delay: %u<br/>\r\n",pxt2dly);
      state.client.write(outstr);
      sprintf(outstr,"Timer5 delay: %u<br/>\r\n",pxt5dly);
      state.client.write(outstr);
      sprintf(outstr,"Timer7 delay: %u<br/>\r\n",pxt7dly);
      state.client.write(outstr);
      sprintf(outstr,"Timer3 slow divider: %u<br/>\r\n",tmr3_slow_div);
      state.client.write(outstr);
    }
    sprintf(outstr,"5V supply voltage [V]: %.2f<br/>\r\n",ina_bus_voltage(INA232_addr));
    state.client.write(outstr);
    sprintf(outstr,"5V supply current [A]: %.2f<br/>\r\n",ina_shunt_voltage(INA232_addr)/0.03f);
    state.client.write(outstr);
    sprintf(outstr,"Theta tracker state: %u<br/>\r\n",opt_state);
    state.client.write(outstr);
    sprintf(outstr,"Motor speed [RPS]: %f<br/>\r\n",get_motor_speed());
    state.client.write(outstr);
    sprintf(outstr,"Elapsed time [ms]: %u<br/>\r\n",display_active_time);
    state.client.write(outstr);
    if(bright_mode==0){
      state.client.write(("Brightness <b>0</b> | <a href='/b?bm=1'>1</a> | <a href='/b?bm=2'>2</a><br/>\r\n"));
    }else{
      if(bright_mode==1){
        state.client.write(("Brightness <a href='/b?bm=0'>0</a> | <b>1</b> | <a href='/b?bm=2'>2</a><br/>\r\n"));
      }else{
        state.client.write(("Brightness <a href='/b?bm=0'>0</a> | <a href='/b?bm=1'>1</a> | <b>2</b><br/>\r\n"));
      }
    }
    sprintf(outstr,"Theta pixel shift: %f | <a href='/p?ps=1'>-10</a> <a href='/p?ps=2'>-1</a> <a href='/p?ps=3'>-0.1</a> <a href='/p?ps=4'>-0.01</a> <a href='/p?ps=6'>+0.01</a> <a href='/p?ps=7'>+0.1</a> <a href='/p?ps=8'>+1</a> <a href='/p?ps=9'>+10</a><br/>\r\n",theta_pixel_shift);
    state.client.write(outstr);
    sprintf(outstr,"Theta pixel Vshift: %f | <a href='/p?vs=1'>-10</a> <a href='/p?vs=2'>-1</a> <a href='/p?vs=3'>-0.1</a> <a href='/p?vs=7'>+0.1</a> <a href='/p?vs=8'>+1</a> <a href='/p?vs=9'>+10</a><br/>\r\n",theta_pixel_vshift);
    state.client.write(outstr);
    sprintf(outstr,"North pixel shift: %i | <a href='/p?ns=1'>-10</a> <a href='/p?ns=2'>-1</a> <a href='/p?ns=8'>+1</a> <a href='/p?ns=9'>+10</a><br/>\r\n",north_pixel_shift);
    state.client.write(outstr);
    sprintf(outstr,"Theta alpha (0=no avg, 1=inf avg): %f | <a href='/p?ta=2'>-0.1</a> <a href='/p?ta=3'>-0.01</a> <a href='/p?ta=4'>-0.001</a> <a href='/p?ta=6'>+0.001</a> <a href='/p?ta=7'>+0.01</a> <a href='/p?ta=8'>+0.1</a><br/>\r\n",theta_alpha);
    state.client.write(outstr);
    sprintf(outstr,"Omega alpha (0=no avg, 1=inf avg): %f | <a href='/p?oa=2'>-0.1</a> <a href='/p?oa=3'>-0.01</a> <a href='/p?oa=4'>-0.001</a> <a href='/p?oa=6'>+0.001</a> <a href='/p?oa=7'>+0.01</a> <a href='/p?oa=8'>+0.1</a><br/>\r\n",omega_alpha);
    state.client.write(outstr);
    sprintf(outstr,"Motor setpoint: %u | <a href='/p?ms=1'>-100</a> <a href='/p?ms=2'>-10</a> <a href='/p?ms=8'>+10</a> <a href='/p?ms=9'>+100</a><br/>\r\n",motor_default_speed);
    state.client.write(outstr);
    
    sprintf(outstr,"Slow motor errors: %u<br/>\r\n",err_slow);
    state.client.write(outstr);
    sprintf(outstr,"Index lock errors: %u<br/>\r\n",err_lock);
    state.client.write(outstr);
    sprintf(outstr,"Encoder interrupt interval min/max time [us]: %u / %u<br/>\r\n",opt1_el_min,opt1_el_max);
    state.client.write(outstr);
    sprintf(outstr,"Encoder interrupt duration min/max time [us]: %u / %u<br/>\r\n",opt1_dur_min,opt1_dur_max);
    state.client.write(outstr);
    sprintf(outstr,"Pixel interrupt interval min/max time [us]: %u / %u<br/>\r\n",opt2_el_min,opt2_el_max);
    state.client.write(outstr);
    sprintf(outstr,"Pixel interrupt duration min/max time [us]: %u / %u<br/>\r\n",opt2_dur_min,opt2_dur_max);
    state.client.write(outstr);
    //reset counters
    opt1_el_min=1000000; opt1_el_max=0; opt1_dur_min=1000000; opt1_dur_max=0; opt2_el_min=1000000; opt2_el_max=0; opt2_dur_min=1000000; opt2_dur_max=0;
    sprintf(outstr,"Binary data bytes received: %u<br/>\r\n",ethBytesReceived);
    state.client.write(outstr);
    sprintf(outstr,"Ethernet data , buffer generation max time [us]: %u , %u<br/>\r\n",ethDataMaxTime,pixGenMaxTime);
    state.client.write(outstr);
    //reset counters
    ethDataMaxTime=0; pixGenMaxTime=0;
    state.client.write("<a href='/'>Refresh</a><br/>\r\n");
    state.client.write("</body></html>");
    state.client.flush();
  
    // Half close the connection, per
    // [Tear-down](https://datatracker.ietf.org/doc/html/rfc7230#section-6.6)
    state.client.closeOutput();
    state.closedTime = millis();
    state.outputClosed = true;
    state.keepopen = false;
    state.parsingState=255;//no further action
  }
}

byte hex2byte(char arr[], int index){
  //0-F, two characters
  byte t1, t2;
  t1=hex2byte1(arr[index]);
  t1<<=4;
  t2=hex2byte1(arr[index+1]);
  return (t1|t2);
}

byte hex2byte1(char hex){
  byte t1;
  if(hex<'0'){
    return 0;
  }
  t1=hex-'0'; //set so '0'==0
  if(t1>9){
    t1-=7; //set so 'A'==10
  }
  if(t1>=42){
    t1-=32; //set so 'a'==10
  }
  if(t1>15){
    t1=15;
  }
  return t1;
}

void processEthernetClients(){
  EthernetClient client = server.accept();
  if (client) {
    // We got a connection!
    //IPAddress ip = client.remoteIP();
    //Serial.printf("Client connected: %u.%u.%u.%u\r\n", ip[0], ip[1], ip[2], ip[3]);
    clients.emplace_back(std::move(client));
    //printf("Client count: %zu\r\n", clients.size());
  }

  // Process data from each client
  for (ClientState &state : clients) {  // Use a reference so we don't copy
    if (!state.client.connected()) {
      state.closed = true;
      continue;
    }

    // Check if we need to force close the client
    if (state.outputClosed) {
      if (millis() - state.closedTime >= kShutdownTimeout) {
        //IPAddress ip = state.client.remoteIP();
        //Serial.printf("Client shutdown timeout: %u.%u.%u.%u\r\n",ip[0], ip[1], ip[2], ip[3]);
        state.client.close();
        state.closed = true;
        continue;
      }
    } else {
      if ((!state.keepopen)&&(millis() - state.lastRead >= kClientTimeout)) {
        //IPAddress ip = state.client.remoteIP();
        //Serial.printf("Client timeout: %u.%u.%u.%u\r\n", ip[0], ip[1], ip[2], ip[3]);
        state.client.close();
        state.closed = true;
        continue;
      }
    }

    processClientData(state);
  }

  // Clean up all the closed clients
  size_t size = clients.size();
  clients.erase(std::remove_if(clients.begin(), clients.end(),
                               [](const auto &state) { return state.closed; }),
                clients.end());
  if (clients.size() != size) {
    //printf("New client count: %zu\r\n", clients.size());
    disconnect_timer=0;
  }
  if(clients.size()==0){
    if(display_active && (disconnect_stopdisplay!=0) && (disconnect_timer>disconnect_stopdisplay)){
      stopDisplay(); 
    }
  }
}

__attribute__((section(".fastrun"),noinline,noclone,optimize("Os"))) void updateFlashFirmware(uint32_t numbytes){
  if(numbytes>firmware_buffer_length){
    return;
  }
  stopDisplay();//make sure nothing is operational
  digitalWriteFast(13, HIGH);
  //erase flash sectors as we go along
  uint32_t wrbytes=0;
  int32_t rbytes=numbytes;
  uint32_t addr=flash_offset;
  uint32_t adbuf=firmware_buffer;
  int32_t txb=0;
  while(rbytes>0){
    /*if(rbytes>=65536){
      eepromemu_flash_erase_64K_block((void*)addr);
      txb=655536;
    }else{
      if(rbytes>=32768){
        eepromemu_flash_erase_32K_block((void*)addr);
        txb=32768;
      }else{*/
        eepromemu_flash_erase_sector((void*)addr);
        if(rbytes>=4096){
          txb=4096;
        }else{
          txb=rbytes;
        }
      //}
    //}
    while(txb>0){
      eepromemu_flash_write((void*)addr, (void*)adbuf, 4);
      addr+=4;
      adbuf+=4;
      rbytes-=4;
      txb-=4;
    }
  }
  for(int a=0; a<10; a++){
    digitalToggleFast(13);
    delay(500);//for visual indication
  }
  digitalWriteFast(13, LOW);
  //REBOOT;
  *((uint32_t *)0xE000ED0C)=0x05FA0004;//CPU Restart value
  while(true) { } //stall
}

