﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AstroDisplayUI
{
    /// <summary>
    /// Interaction logic for CirclePlot.xaml
    /// </summary>
    public partial class CirclePlot : UserControl
    {
        public CirclePlot()
        {
            InitializeComponent();
        }

        public void SetColors(Brush bg, Brush fg)
        {
            Ellipse bge = (Ellipse)PlotCanvas.Children[0];
            bge.Fill = bg;
            bge.Stroke = fg;
        }

        public void PlotRect(double x, double y, Brush f, double s, string tt = null)
        {
            //x,y in range (-1,1)
            Ellipse pte = new Ellipse() { Fill = f, Width = s, Height = s };
            Canvas.SetLeft(pte, 100 + x * 99 - s / 2);
            Canvas.SetTop(pte, 100 - y * 99 - s / 2);
            Canvas.SetZIndex(pte, 10);//move to front of constellation lines
            pte.ToolTip = tt;
            PlotCanvas.Children.Add(pte);
        }

        public void PlotRectLine(double x1, double y1, double x2, double y2, Brush f, double s, string tt = null)
        {
            //x,y in range (-1,1)
            Line pte = new Line() { Stroke = f, StrokeThickness = s };
            pte.X1 = 100 + x1 * 99;
            pte.Y1 = 100 - y1 * 99;
            pte.X2 = 100 + x2 * 99;
            pte.Y2 = 100 - y2 * 99;
            pte.ToolTip = tt;
            PlotCanvas.Children.Add(pte);
        }

        public void PlotPol(double t, double r, Brush f, double s, string tt)
        {
            double x = Math.Cos(t) * r;
            double y = Math.Sin(t) * r;
            PlotRect(x, y, f, s, tt);
        }

        public void PlotPrj(double t, double p, Brush f, double s, string tt)
        {
            double x = Math.Cos(t) * Math.Cos(p);
            double y = Math.Sin(t) * Math.Cos(p);
            PlotRect(x, y, f, s, tt);
        }

        public void PlotPrjLine(double t1, double p1, double t2, double p2, Brush f, double s)
        {
            double x1 = Math.Cos(t1) * Math.Cos(p1);
            double y1 = Math.Sin(t1) * Math.Cos(p1);
            double x2 = Math.Cos(t2) * Math.Cos(p2);
            double y2 = Math.Sin(t2) * Math.Cos(p2);
            PlotRectLine(x1, y1, x2, y2, f, s);
        }

        public void ClearPlot()
        {
            Ellipse bge = (Ellipse)PlotCanvas.Children[0];
            PlotCanvas.Children.Clear();
            PlotCanvas.Children.Add(bge);
        }
    }
}
