opheight=8; %output points height
opwidth=12; %output points width
opsep=0.5; %[m] output points separation
opoff=5; %output points offset from plane
sr=9765; %[Hz] sample rate
ipheight=8;
ipwidth=12;
ipsep=0.3048; %[m] input points separation
vc=343;
tdur=0.1; %[s] duration of analysis
sdur=ceil(tdur*sr); %[samples] duration of analysis

[ipgridx,ipgridy]=meshgrid(1:ipwidth,1:ipheight);
ipgridx=(ipgridx-(ipwidth+1)/2)*ipsep; %center on zero
ipgridy=(ipgridy-(ipheight+1)/2)*ipsep; %center on zero

[opgridx,opgridy,opgridz]=meshgrid(1:opwidth,1:opheight,1:opoff);
opgridx=(opgridx-(opwidth+1)/2)*opsep; %center on zero
opgridy=(opgridy-(opheight+1)/2)*opsep; %center on zero
opgridz=opgridz*opsep;

tstart=5;  %[s] time to start analysis
phs=zeros(opheight,opwidth,opoff);
mag=phs;

fmin=200; %[Hz] frequency binning for amplitude
fmax=3000;
fphs=1200; %[Hz] frequency for phase
fftl=1+floor(sdur/2);

parfor oz=1:opoff
    mgo=zeros(opheight,opwidth);
    pho=mgo;
    disp(oz);
    for ox=1:opwidth
        for oy=1:opheight
            x=opgridx(1,ox,1);
            y=opgridy(oy,1,1);
            z=opgridz(1,1,oz);
            dvs=sqrt((ipgridx-x).^2+(ipgridy-y).^2+(z.^2));
            dts=(dvs/vc);
            fcf=zeros(1,fftl);
            f=fcf;
            for ix=1:ipwidth
                for iy=1:ipheight
                    tsi=tstart+dts(iy,ix);
                    sstart=1+round(tsi*sr);                    
                    dat=rf(iy+(ix-1)*9,sstart:(sstart+sdur-1));
                    [q,f]=fftreal(dat,sr);
                    tsa=(sstart-1)/sr;
                    ps=mod(f*tsa,1)*2*pi;
                    fcf=fcf+q.*exp(-1i*ps);
                end
            end
            m=abs(fcf);
            [~,b]=min(abs(f-fphs));
            pho(oy,ox)=angle(fcf(b));
            mgo(oy,ox)=sum(m((f>=fmin)&(f<=fmax)));
        end
    end
    phs(:,:,oz)=pho;
    mag(:,:,oz)=mgo/(opheight*opwidth);
end