if(~exist('rf','var'))
    fileID=fopen('rec96test4.raw','r');
    rf=fread(fileID,[108,Inf],'int16','b');
    fclose(fileID);
end

opheight=8; %output points height
opwidth=12; %output points width
opsep=0.5; %[m] output points separation
opoff=1; %[m] output points offset from plane
sr=9765; %[Hz] sample rate
ipheight=8;
ipwidth=12;
ipsep=0.3048; %[m] input points separation
vc=343;
tdur=0.1; %[s] duration of analysis
sdur=ceil(tdur*sr); %[samples] duration of analysis

[ipgridx,ipgridy]=meshgrid(1:ipwidth,1:ipheight);
ipgridx=(ipgridx-(ipwidth+1)/2)*ipsep; %center on zero
ipgridy=(ipgridy-(ipheight+1)/2)*ipsep; %center on zero

[opgridx,opgridy]=meshgrid(1:opwidth,1:opheight);
opgridx=(opgridx-(opwidth+1)/2)*opsep; %center on zero
opgridy=(opgridy-(opheight+1)/2)*opsep; %center on zero

t=linspace(1,14,250);  %[s] time to start analysis
nt=length(t);
phs=zeros(opheight,opwidth,nt);
mag=phs;

fmin=300; %[Hz] frequency binning for amplitude
fmax=700;
fphs=400; %[Hz] frequency for phase

parfor ti=1:nt
    mgo=zeros(opheight,opwidth);
    pho=mgo;
    disp(ti);
    tstart=t(ti);
    for ox=1:opwidth
        for oy=1:opheight
            x=opgridx(1,ox);
            y=opgridy(oy,1);
            z=opoff;
            dvs=sqrt((ipgridx-x).^2+(ipgridy-y).^2+z.^2);
            dts=(dvs/vc)-(opoff/vc);
            fcf=zeros(1,1+floor(sdur/2));
            f=fcf;
            for ix=1:ipwidth
                for iy=1:ipheight
                    tsi=tstart+dts(iy,ix);
                    sstart=1+round(tsi*sr);                    
                    dat=rf(iy+(ix-1)*9,sstart:(sstart+sdur-1));
                    [q,f]=fftreal(dat,sr);
                    tsa=(sstart-1)/sr;
                    ps=mod(f*tsa,1)*2*pi;
                    fcf=fcf+q.*exp(-1i*ps);
                end
            end
            m=abs(fcf);
            [~,b]=min(abs(f-fphs));
            pho(oy,ox)=angle(fcf(b));
            mgo(oy,ox)=sum(m((f>=fmin)&(f<=fmax)));
        end
    end
    phs(:,:,ti)=pho;
    mag(:,:,ti)=mgo/(opheight*opwidth);
end