opheight=12; %output points height
opwidth=12; %output points width
opoff=0.8; %[m] output points offset from plane
opsep=0.4; %[m] output points separation
sr=9765; %[Hz] sample rate
ipheight=8;
ipwidth=12;
ipsep=0.3048; %[m] input points separation
vc=343;
tdur=0.1; %[s] duration of analysis
sdur=ceil(tdur*sr); %[samples] duration of analysis
twv=linspace(0,tdur,sdur);
swv=sin(twv*fr*2*pi);
cwv=cos(twv*fr*2*pi);

[ipgridx,ipgridy]=meshgrid(1:ipwidth,1:ipheight);
ipgridx=(ipgridx-(ipwidth+1)/2)*ipsep; %center on zero
ipgridy=(ipgridy-(ipheight+1)/2)*ipsep; %center on zero

[opgridx,opgridy]=meshgrid(1:opwidth,1:opheight);
opgridx=(opgridx-(opwidth+1)/2)*opsep; %center on zero
opgridy=(opgridy-(opheight+1)/2)*opsep-1.15; %center on zero

t=linspace(2,4,240);  %[s] time to start analysis
nt=length(t);
mag=zeros(opheight,opwidth,nt);

parfor ti=1:nt
    disp(ti);
    tstart=t(ti);
    for ox=1:opwidth
        for oy=1:opheight
            x=opgridx(1,ox);
            y=opgridy(oy,1);
            z=opoff;
            dvs=sqrt((ipgridx-x).^2+(ipgridy-y).^2+z.^2);
            dts=(dvs/vc)-(opoff/vc);
            fcf=zeros(1,sdur);
            for ix=1:ipwidth
                for iy=1:ipheight
                    tsi=tstart+dts(iy,ix);
                    sstart=1+round(tsi*sr);
                    dat=rf(iy+(ix-1)*9,sstart:(sstart+sdur-1));
                    dat=dat-mean(dat);
                    fcf=fcf+dat;
                end
            end
            mag(oy,ox,ti)=var(fcf)/(sdur*ipwidth*ipheight);
        end
    end
end