function [q, f]=fftreal(din,sr)
    arguments
        din
        sr = 1
    end
    fres=fft(din);
    L=length(fres);
    fres=fres/L;
    %first entry is DC component (average) and should be unchanged
    %further elements are mirrored
    if(mod(L,2)==0)
        q=[fres(1), 2*fres(2:(L/2)), fres((L/2)+1)];
    else
        q=[fres(1), 2*fres(2:ceil(L/2))];
    end
    f = sr*(0:floor(L/2))/L;
end