function fftbode(din,sr,uselog,inczero)
    arguments
        din
        sr
        uselog = false
        inczero = false
    end
    L=length(din);
    [fres,f]=fftreal(din,sr);
    if(~inczero || uselog)
        f(1)=[];
        fres(1)=[];
    end
    P1 = abs(fres);
    P2 = angle(fres)*180/pi; %[deg]
    subplot(2,1,1);
    if(uselog)
        loglog(f,P1);
    else
        plot(f,P1);
    end
    title(sprintf('FFT %i datapoints at %i sa/s, %.2f Hz bins', L, sr, f(2)-f(1)));
    %xlabel('Frequency [Hz]');
    ylabel('Amplitude');
    subplot(2,1,2);
    if(uselog)
        semilogx(f,P2);
    else
        plot(f,P2);
    end
    %title(sprintf('FFT %i datapoints at %i sa/s, %.2f Hz bins', L, sr, f(2)-f(1)));
    xlabel('Frequency / Hz');
    ylabel('Phase / deg');
end