function out = FindCollisions(particles_loc, collision_rad)
%% Find collisions within a particle locations array in 3D
% input: particles_loc [n by 3] each row is [x y z] location
%           collision_rad radius around each particle within which
%           collision occurs
% output: out [n by 2] each row is [index1 index2] pair of colliding
%   particles indices where two particles are within 2*collision_rad
%   only the first pair in a more than two body collision is returned, with
%   arbitrary preference

num_particles=size(particles_loc, 1);
% proc_particles=false(num_particles,1);
outr=zeros(num_particles,1);
for(i=1:num_particles-1)
%     if(proc_particles(i))
%         continue;
%     end
%     proc_particles(i)=true;
    md=abs(particles_loc(i+1:end,1)-particles_loc(i,1))+abs(particles_loc(i+1:end,2)-particles_loc(i,2))+abs(particles_loc(i+1:end,3)-particles_loc(i,3)); %'Manhattan distance' as a first estimate for where full distance is required
    coll=find(md<1.732*2*collision_rad); % use sqrt(3) for corner cases in 3D
    if(~isempty(coll))
        for(l=1:length(coll))
            c2=i+coll(l);
            dm1=particles_loc(c2,:);
            dm2=particles_loc(i,:);
            dist=sqrt(sum((dm1-dm2).^2));
            if(dist<2*collision_rad)
                outr(i)=c2;
%               proc_particles(c2)=true; % if no collision, there is still a possibility for one later
                break; % if no collision, look at remainder of coll array
            end
        end
    end
end
outl=find(outr~=0);
out=[outl outr(outl)];