%% 2-Dimensional particles-in-box elastic collision simulation

col_rad=0.2; % when two particles are within their collision radius or within radius of wall a collision is processed
box_size=10; % box internal dimension x=y
num_particles=100; % number of particles
num_iter=250; % number of iterations
wall_refl=1; % particle condition at wall: 0=wrap-around, 1=mirror

particle_loc=rand(num_particles, 3)*box_size; % locations in x,y,z are uniformly random
particle_loc(:,3)=0; % zero z location for 2D case

particle_svel=zeros(num_particles*num_iter,1); %squared velocities for averaging

%% requirement for this algorithm is that initially particles do not collide with outward velocity vector
% we simplify this to simply no collisions at the beginning
rc=0;
while(rc<num_particles) % allowed randomization steps
    coll=FindCollisions(particle_loc, col_rad);
    if(isempty(coll))
        break;
    end
    particle_loc(coll(1),:)=[rand()*box_size rand()*box_size 0]; % find new random location that doesn't cause collision
    rc=rc+1;
end

if(rc==num_particles)
    disp('Randomization error');
    return;
end

vel_angles=rand(num_particles,1)*2*pi(); % uniformly distributed velocity angularly
vel_mag=1;%rand(num_particles,1)*sqrt(3);%linspace(0,sqrt(3),num_particles)'; % constant or random or linearly varying magnitude such that RMS=1
%particle_vel=[vel_mag.*sin(vel_angles) vel_mag.*cos(vel_angles) zeros(num_particles,1)]; % velocities in x,y,z

particle_vel=[[vel_mag*2*ones(num_particles/2,1); zeros(num_particles/2,1)] zeros(num_particles,2)];

%plot(particle_loc(:,1),particle_loc(:,2),'o');

dt=0.1;

for(i=1:num_iter)
    particle_loc=particle_loc+particle_vel*dt;
    coll=FindCollisions(particle_loc, col_rad);
    for(j=1:size(coll,1))
        coll_v=particle_loc(coll(j,1),:)-particle_loc(coll(j,2),:);
        coll_uv=coll_v/sqrt(sum(coll_v.^2)); % collision unit vector
        v1_c=dot(particle_vel(coll(j,1),:), coll_uv);
        v2_c=dot(particle_vel(coll(j,2),:), coll_uv);
        if(v2_c<v1_c)
            continue; % the velocities are incorrect for a collision - particles moving away
        end
        
        v1_cv=v1_c*coll_uv; % velocity projected along collision vector
        v1_ncv=particle_vel(coll(j,1),:)-v1_cv;
        v2_cv=v2_c*coll_uv;
        v2_ncv=particle_vel(coll(j,2),:)-v2_cv;
        
        particle_vel(coll(j,1),:)=v1_ncv+v2_cv; % exchange the collision vector velocities and keep the rest
        particle_vel(coll(j,2),:)=v2_ncv+v1_cv;
    end
    
    particle_loc(particle_loc(:)<0)=box_size+particle_loc(particle_loc(:)<0);
    particle_loc(particle_loc(:)>box_size)=particle_loc(particle_loc(:)>box_size)-box_size;
    
    particle_svel(1+(i-1)*num_particles:i*num_particles)=sqrt(sum(particle_vel.^2,2));
    
    if(mod(i,5)==1)
    plot(particle_loc(:,1),particle_loc(:,2),'o','MarkerSize',10);
    axis([0 box_size 0 box_size]);
    %fig=gcf;
    %set(fig, 'PaperUnits', 'inches', 'PaperPosition', [0 0 440 320]/150); %see https://stackoverflow.com/questions/7218697/matlab-saving-figure-with-predefined-size
    
    %hold on
    %plot(particle_loc(coll(:),1),particle_loc(coll(:),2),'or');
    %hold off
    
    %hist(sqrt(sum(particle_vel.^2,2)));
    
        %histogram(particle_svel(1:i*num_particles),'Normalization','pdf');
        %axis([0 3 0 3]);
        pause(0.1)
    
        frame=getframe(1);
        img=frame2im(frame); %print(fig, '-r150', '-RGBImage');
        [A,map]=rgb2ind(img,2);
        if(i==1)
            imwrite(A,map,'2ColSquare.gif','gif','LoopCount',Inf,'DelayTime',0.5);
        else
            imwrite(A,map,'2ColSquare.gif','gif','WriteMode','append','DelayTime',0.05);
        end
    end
end

histogram(particle_svel,'Normalization','pdf');

hold on
% v=linspace(0,max(particle_svel)); %velocity distribution - Maxwell distribution
% T=(rms(vel_mag)^2)/1.5; %expected temp. based on R=1, M=2, v_rms = rms(vel_mag) in formula on http://hyperphysics.phy-astr.gsu.edu/hbase/Kinetic/kintem.html#c3
% mbd=4*pi()*(1/(T*pi()))^(3/2)*v.^2.*exp(-v.^2/T);
% plot(v,mbd);