//animate spherical mass motion from spherical.sce

param3d(pos_store(1,:),pos_store(2,:),pos_store(3,:))
gce().foreground=16;
gca().parent.figure_size=[380 380];

pos_mult=point_every/trace_every;

for(i=1:point_len)
    
    drawlater
    if(i>1)
        delete(gca().children(1:2)); //delete drawn arrow and point
    end
    
    pos=pos_store(:,i*pos_mult);
    scatter3([%nan pos(1)],[0 pos(2)],[0 pos(3)],40,'blue','fill')
    
    btrv=bas_store(:,i,3);
    bfwd=bas_store(:,i,2);
    ftrv=frc_store(3,i)*5000;
    ffwd=frc_store(2,i)*50000;
    
    xarrows([pos(1)-btrv(1)*ftrv pos(1)-bfwd(1)*ffwd; pos(1) pos(1)],[pos(2)-btrv(2)*ftrv pos(2)-bfwd(2)*ffwd; pos(2) pos(2)],[pos(3)-btrv(3)*ftrv pos(3)-bfwd(3)*ffwd; pos(3) pos(3)],20,[5 3])
    
    isoview on
    gca().rotation_angles = [77, -43];
    gca().axes_visible="off";
    gca().data_bounds=[-11 -11 -11;11 11 11]
    gca().y_label.visible="off"
    gca().x_label.visible="off"
    gca().z_label.visible="off"
    drawnow
    
    xs2png(gcf(),strcat(['C:\Users\Max\Documents\Scilab\spherical_motion\gyro6\m43deg_',string(i),'.png']));
    
    sleep(100);
end

