//3d spherical motion simulation

r=10;
m=1;
vfwd=0.15;//use around 0.0725 at f_trv=y/10000 for limiting case
position=[0;r;0];
velocity=[vfwd;0;0];
dt=0.1;
inum=14000;

//for gyro1 animation, vfwd=0.4, m=1, r=10, dt=0.1, inum=10000, trace_every=10, point_every=100
//for gyro2 animation, vfwd=0.2, m=1, r=10, dt=0.1, inum=10000, trace_every=20, point_every=200
//for gyro3 animation, vfwd=0.070629, inum=30000, trace_every=40, point_every=400
//gyro4 -> vfwd=0.5, inum=4050, dt=0.05, trace_every=5, point_every=50

i=0;
trace_every=20;
trace_ind=0;
point_every=200;
point_ind=0;

trace_len=floor(inum/trace_every);
point_len=floor(inum/point_every);
pos_store=zeros(3,trace_len);
vel_store=zeros(3,point_len);
frc_store=zeros(3,point_len);
bas_store=zeros(3,point_len,3);

while i<inum
    basis_rad=position./norm(position);
    basis_fwd=velocity./norm(velocity);
    //basis_fwd=basis_fwd-basis_rad*sum(basis_fwd.*basis_rad);
    //basis_fwd=basis_fwd./norm(basis_fwd);
    basis_trv=cross(basis_rad,basis_fwd);
    basis_trv=basis_trv./norm(basis_trv);
    
    //if(i>2502)
        f_trv=position(1)/10000;
        //f_trv=0.03;
        //going around a circle with symmetric +- transverse force:
        //the position returns to the same point
        //but the velocity vector rotates!
    //else
        //f_trv=0;
    //end
    
    //f_fwd=0;
    
    position_next=position+basis_fwd.*(vfwd*dt)-basis_rad.*(0.5*vfwd^2/r*dt^2);
    //position_next=position_next+basis_fwd.*(0.5*f_fwd/m*dt^2);
    position_next=position_next+basis_trv.*(0.5*f_trv/m*dt^2);
    
    dvt=f_trv/m*dt;
    vfwd2=sqrt(vfwd^2+dvt^2);
    fcr=vfwd2^2/r;
    
    vps=abs(vfwd)+abs(dvt);
    vrsq=0.5*(fcr)^2*dt^2;
    velocity_next=velocity-basis_rad.*(fcr*dt)+basis_trv.*(dvt);
    velocity_next=velocity_next-basis_trv.*(dvt/vps)*vrsq;
    velocity_next=velocity_next-basis_fwd.*(vfwd/vps)*vrsq;
    //velocity_next=velocity_next+basis_fwd.*(f_fwd/m*dt);
    
    //update for next time step
    vfwd=norm(velocity_next);
    velocity=velocity_next;
    position=position_next;
    i=i+1;
    
    if(modulo(i,trace_every)==0)
        trace_ind=trace_ind+1;
        pos_store(:,trace_ind)=position;
    end
    if(modulo(i,point_every)==0)
        point_ind=point_ind+1;
        vel_store(:,point_ind)=velocity;
        frc_store(:,point_ind)=[m*fcr; 0; f_trv];
        bas_store(:,point_ind,1)=basis_rad;
        bas_store(:,point_ind,2)=basis_fwd;
        bas_store(:,point_ind,3)=basis_trv;
    end
end

drawlater
param3d(pos_store(1,:),pos_store(2,:),pos_store(3,:))
gce().foreground=2;
isoview on
gca().rotation_angles = [80, 80];
drawnow
