//gyroscope analytic motion plotter
w=2*%pi/500; //rad/s gyroscope rotor speed
psi=w/5; //rad/s gyroscope tilting speed about x-axis
r=10; //rotor radius
m=1; //point mass
t=linspace(0,1000,200); //time

trace_every=1;
point_every=4;

trace_len=floor(length(t)/trace_every);
point_len=floor(length(t)/point_every);

//pos_store=zeros(3,trace_len);
//vel_store=zeros(3,point_len);
//frc_store=zeros(3,point_len);
bas_store=zeros(3,point_len,3);

pos_t=t(trace_every:trace_every:length(t));
vel_t=t(point_every:point_every:length(t));

pos_store=r*[sin(w*pos_t); cos(w*pos_t).*cos(psi*pos_t); cos(w*pos_t).*sin(psi*pos_t)]; //analytic positions
//[x;y;z]
vel_store=r*[w*cos(w*vel_t); -psi*cos(w*vel_t).*sin(psi*vel_t)-w*sin(w*vel_t).*cos(psi*vel_t); psi*cos(w*vel_t).*cos(psi*vel_t)-w*sin(w*vel_t).*sin(psi*vel_t)]; //analytic velocity = dp/dt
acc_store=r*[-w^2*sin(w*vel_t); (2*psi*w)*sin(w*vel_t).*sin(psi*vel_t)-(psi^2+w^2)*cos(w*vel_t).*cos(psi*vel_t); (-2*psi*w)*sin(w*vel_t).*cos(psi*vel_t)-(psi^2+w^2)*cos(w*vel_t).*sin(psi*vel_t)]; //analytic acceleration = dv/dt

//following are analytical solutions
s=sqrt(w^2+psi^2*cos(w*vel_t).^2);
//vabs=sqrt(sum(v.^2,1));
vabs=r*s;

frc_store=r*m*[-(w^2+psi^2*cos(w*vel_t).^2);
 -(1./s)*(psi^2*w).*sin(w*vel_t).*cos(w*vel_t);
 (1./s)*psi.*sin(w*vel_t).*(2*w^2+cos(w*vel_t).^2*psi^2)]; //forces (rad, fwd, trv)

//aabs=sqrt(sum(a.^2,1));
//aabs2=sqrt(a_r.^2+a_fwd.^2+a_trv.^2);

bas_store(:,:,1)=[sin(w*vel_t); cos(w*vel_t).*cos(psi*vel_t); cos(w*vel_t).*sin(psi*vel_t)];
bas_store(:,:,2)=[(1./s)*w.*cos(w*vel_t); (1./s).*(-psi*cos(w*vel_t).*sin(psi*vel_t)-w*sin(w*vel_t).*cos(psi*vel_t)); (1./s).*(psi*cos(w*vel_t).*cos(psi*vel_t)-w*sin(w*vel_t).*sin(psi*vel_t))];
bas_store(:,:,3)=[(1./s)*psi.*cos(w*vel_t).^2; (1./s).*(-psi*cos(w*vel_t).*sin(w*vel_t).*cos(psi*vel_t)+w*sin(psi*vel_t)); (1./s).*(-psi*cos(w*vel_t).*sin(w*vel_t).*sin(psi*vel_t)-w*cos(psi*vel_t))];

//return

//dp=sum(a.*v,1); //dot product - zero if all acceleration is radial and transverse, nonzero if some acceleration is in direction of velocity
//plot(dp);
//return

//param3d(pos_store(1,:),pos_store(2,:),pos_store(3,:))
//isoview on
return

varr_ind=1:2:length(t);
varr_x=zeros(2,length(varr_ind));
varr_y=zeros(2,length(varr_ind));
varr_z=zeros(2,length(varr_ind));
aarr_x=varr_x;
aarr_y=varr_y;
aarr_z=varr_z;
j=1;
varr_sc=0.1;
aarr_sc=1;
for(vi=varr_ind)
    varr_x(1,j)=p(1,vi);
    varr_y(1,j)=p(2,vi);
    varr_z(1,j)=p(3,vi);
    aarr_x(2,j)=p(1,vi);
    aarr_y(2,j)=p(2,vi);
    aarr_z(2,j)=p(3,vi);
    varr_x(2,j)=varr_x(1,j)+v(1,vi)*varr_sc;
    varr_y(2,j)=varr_y(1,j)+v(2,vi)*varr_sc;
    varr_z(2,j)=varr_z(1,j)+v(3,vi)*varr_sc;
    aarr_x(1,j)=aarr_x(2,j)-a_trv(vi)*basis_trv(1,vi)*aarr_sc;
    aarr_y(1,j)=aarr_y(2,j)-a_trv(vi)*basis_trv(2,vi)*aarr_sc;
    aarr_z(1,j)=aarr_z(2,j)-a_trv(vi)*basis_trv(3,vi)*aarr_sc;
    j=j+1;
end
//xarrows(varr_x,varr_y,varr_z,1,3)
xarrows(aarr_x,aarr_y,aarr_z,1,5)
