//gyroscope analytic motion plotter

function render_external_sph(psi, omega)
    ext_r=10; //external sphere radius
    e_thetas=0:%pi/4:%pi/2; //where the lines are drawn
    //e_thetas($)=[];
    e_respts=40;
    e_ws=linspace(0,2*%pi,e_respts);
    circ_pts=ext_r*[ cos(e_ws); zeros(1,e_respts); sin(e_ws);]; //circle fragments to rotate
    ext_sph=zeros(3,e_respts*length(e_thetas));
    ei=0;
    col=[16 15 24 21]; //color indices
    for(ext_theta=e_thetas)
        a=0;
        b=omega;//+%pi/2;
        c=psi+ext_theta;
        erot=[cos(a)*cos(b), cos(a)*sin(b)*sin(c)-sin(a)*cos(c), cos(a)*sin(b)*cos(c)+sin(a)*sin(c);
            sin(a)*cos(b), sin(a)*sin(b)*sin(c)+cos(a)*cos(c), sin(a)*sin(b)*cos(c)-cos(a)*sin(c);
            -sin(b),cos(b)*sin(c),cos(b)*cos(c)]; //rotation matrix for desired angle
        pts=erot*circ_pts;
        param3d(pts(1,:),pts(2,:),pts(3,:)) //render external axes
        gce().foreground=col(ei+1);
        
        //ext_sph(:,e_respts*ei+(1:e_respts))=pts;
        ei=ei+1;
    end
    
    //param3d(ext_sph(1,:),ext_sph(2,:),ext_sph(3,:)) //render external axes
    //gce().foreground=16;
endfunction

function render_gyro_pts(psi, omega)
    //psi: first rotation about z axis
    //omega: second rotation about newly rotated axis
    //stationary points: z=+-radius, x=0, y=0
    gyro_r=5; //gyro points radius
    e_respts=6; //number of gyro points
    e_ws=linspace(0,2*%pi,e_respts+1);
    e_ws($)=[];
    circ_pts=gyro_r*[ cos(e_ws); zeros(1,e_respts); sin(e_ws);]; //circle fragments to rotate
    ext_sph=zeros(3,e_respts);
    //ei=0;
    //for(ext_theta=e_thetas)
        a=psi;
        b=omega;
        c=0;//ext_theta;
        erot=[cos(a)*cos(b), cos(a)*sin(b)*sin(c)-sin(a)*cos(c), cos(a)*sin(b)*cos(c)+sin(a)*sin(c);
            sin(a)*cos(b), sin(a)*sin(b)*sin(c)+cos(a)*cos(c), sin(a)*sin(b)*cos(c)-cos(a)*sin(c);
            -sin(b),cos(b)*sin(c),cos(b)*cos(c)]; //rotation matrix for desired angle
        pts=erot*circ_pts;
        ext_sph(:,1:e_respts)=pts;
        //ei=ei+1;
    //end
    
    scatter3(ext_sph(1,:),ext_sph(2,:),ext_sph(3,:),40,'blue') //render points
    //gce().foreground=16;
endfunction

function render_arrows(psi, omega)
    a=psi;
    b=omega;//+%pi/2;
    c=0;//psi;
    erot=[cos(a)*cos(b), cos(a)*sin(b)*sin(c)-sin(a)*cos(c), cos(a)*sin(b)*cos(c)+sin(a)*sin(c);
            sin(a)*cos(b), sin(a)*sin(b)*sin(c)+cos(a)*cos(c), sin(a)*sin(b)*cos(c)-cos(a)*sin(c);
            -sin(b),cos(b)*sin(c),cos(b)*cos(c)];
    arr_pts=ext_r/2*[ 1 -1 -1 1;1 1 -1 -1; 0 0 0 0];
    arr_pts=erot*arr_pts;
    xarrows([arr_pts(1,1) arr_pts(1,3);arr_pts(1,2) arr_pts(1,4)],[arr_pts(2,1) arr_pts(2,3);arr_pts(2,2) arr_pts(2,4)],[arr_pts(3,1) arr_pts(3,3);arr_pts(3,2) arr_pts(3,4)],20,[5 5]);
endfunction

//render_external_sph(%pi/4, %pi/3);
//render_gyro_pts(%pi/10,%pi/40);
//isoview on
//gca().axes_visible="off";
//gca().data_bounds=[-11 -11 -11;11 11 11]
//return

w=2*%pi; //rad/s gyroscope rotor speed (initially about x-axis)
psi=w/8; //rad/s gyroscope tilting speed about z-axis
//r=6; //rotor radius
//m=1; //point mass
t=linspace(0,8,100); //time
t($)=[];
point_len=length(t);

for(ti=1:length(t))
    drawlater
    if(ti>1)
        delete(gca().children(:)); //delete drawn points
    end
    if(%t)
        render_external_sph(0, %pi/2);
        render_arrows(-t(ti)*psi, -%pi/2);
        render_gyro_pts(-t(ti)*psi, -t(ti)*w);
    else
        render_external_sph(-t(ti)*psi, -t(ti)*w);
        render_arrows(0, -t(ti)*w);
        render_gyro_pts(0, 0);
    end

    isoview on
    gca().parent.figure_size=[380 380];
    gca().rotation_angles = [78, 114];//78,135
    gca().axes_visible="off";
    gca().box="back_half";//"off";
    gca().data_bounds=[-11 -11 -11;11 11 11]
    gca().y_label.visible="off"
    gca().x_label.visible="off"
    gca().z_label.visible="off"
    drawnow
    
    xs2png(gcf(),strcat(['C:\Users\Max\Documents\Scilab\spherical_motion\gyro9\114deg_',string(ti),'.png']));
    
    sleep(50);    
end

return


trace_every=1;
point_every=4;

trace_len=floor(length(t)/trace_every);
point_len=floor(length(t)/point_every);

//pos_store=zeros(3,trace_len);
//vel_store=zeros(3,point_len);
//frc_store=zeros(3,point_len);
bas_store=zeros(3,point_len,3);

pos_t=t(trace_every:trace_every:length(t));
vel_t=t(point_every:point_every:length(t));

pos_store=r*[sin(w*pos_t); cos(w*pos_t).*cos(psi*pos_t); cos(w*pos_t).*sin(psi*pos_t)]; //analytic positions
//[x;y;z]
vel_store=r*[w*cos(w*vel_t); -psi*cos(w*vel_t).*sin(psi*vel_t)-w*sin(w*vel_t).*cos(psi*vel_t); psi*cos(w*vel_t).*cos(psi*vel_t)-w*sin(w*vel_t).*sin(psi*vel_t)]; //analytic velocity = dp/dt
acc_store=r*[-w^2*sin(w*vel_t); (2*psi*w)*sin(w*vel_t).*sin(psi*vel_t)-(psi^2+w^2)*cos(w*vel_t).*cos(psi*vel_t); (-2*psi*w)*sin(w*vel_t).*cos(psi*vel_t)-(psi^2+w^2)*cos(w*vel_t).*sin(psi*vel_t)]; //analytic acceleration = dv/dt

//following are analytical solutions
s=sqrt(w^2+psi^2*cos(w*vel_t).^2);
//vabs=sqrt(sum(v.^2,1));
vabs=r*s;

frc_store=r*m*[-(w^2+psi^2*cos(w*vel_t).^2);
 -(1./s)*(psi^2*w).*sin(w*vel_t).*cos(w*vel_t);
 (1./s)*psi.*sin(w*vel_t).*(2*w^2+cos(w*vel_t).^2*psi^2)]; //forces (rad, fwd, trv)

//aabs=sqrt(sum(a.^2,1));
//aabs2=sqrt(a_r.^2+a_fwd.^2+a_trv.^2);

bas_store(:,:,1)=[sin(w*vel_t); cos(w*vel_t).*cos(psi*vel_t); cos(w*vel_t).*sin(psi*vel_t)];
bas_store(:,:,2)=[(1./s)*w.*cos(w*vel_t); (1./s).*(-psi*cos(w*vel_t).*sin(psi*vel_t)-w*sin(w*vel_t).*cos(psi*vel_t)); (1./s).*(psi*cos(w*vel_t).*cos(psi*vel_t)-w*sin(w*vel_t).*sin(psi*vel_t))];
bas_store(:,:,3)=[(1./s)*psi.*cos(w*vel_t).^2; (1./s).*(-psi*cos(w*vel_t).*sin(w*vel_t).*cos(psi*vel_t)+w*sin(psi*vel_t)); (1./s).*(-psi*cos(w*vel_t).*sin(w*vel_t).*sin(psi*vel_t)-w*cos(psi*vel_t))];

//return

//dp=sum(a.*v,1); //dot product - zero if all acceleration is radial and transverse, nonzero if some acceleration is in direction of velocity
//plot(dp);
//return


param3d(pos_store(3,:),pos_store(2,:),pos_store(1,:))
//gce().foreground=16;
//gca().parent.figure_size=[380 380];
isoview on
return

pos_mult=point_every/trace_every;

for(i=1) //1:point_len)
    
    drawlater
    if(i>1)
        delete(gca().children(1:2)); //delete drawn arrow and point
    end
    
    pos=pos_store(:,i*pos_mult);
    scatter3([%nan pos(1)],[0 pos(2)],[0 pos(3)],40,'blue','fill')
    
    btrv=bas_store(:,i,3);
    bfwd=bas_store(:,i,2);
    ftrv=frc_store(3,i)*5000;
    ffwd=frc_store(2,i)*50000;
    
    xarrows([pos(1)-btrv(1)*ftrv pos(1)-bfwd(1)*ffwd; pos(1) pos(1)],[pos(2)-btrv(2)*ftrv pos(2)-bfwd(2)*ffwd; pos(2) pos(2)],[pos(3)-btrv(3)*ftrv pos(3)-bfwd(3)*ffwd; pos(3) pos(3)],20,[5 3])
    
    isoview on
    gca().rotation_angles = [80, 83];
    gca().axes_visible="off";
    gca().data_bounds=[-11 -11 -11;11 11 11]
    gca().y_label.visible="off"
    gca().x_label.visible="off"
    gca().z_label.visible="off"
    drawnow
    
    //xs2png(gcf(),strcat(['C:\Users\Max\Documents\Scilab\spherical_motion\gyro6\m43deg_',string(i),'.png']));
    
    sleep(100);
end

